/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ParserFunction<R, T>
extends BiFunction<CommandContext, R, Mono<T>> {
    @SideEffectFree
    public Mono<T> parse(CommandContext var1, R var2) throws InvalidArgumentException;

    @Override
    default public Mono<T> apply(CommandContext context, R raw) throws InvalidArgumentException {
        return this.parse(context, raw);
    }

    @SideEffectFree
    default public <V> ParserFunction<R, V> then(ParserFunction<T, V> after) {
        return new PostParser(this, after);
    }

    public static class PostParser<R, I, T, P1 extends @NonNull ParserFunction<R, I>, P2 extends @NonNull ParserFunction<I, T>>
    implements ParserFunction<R, T> {
        protected final P1 parser;
        protected final P2 postParser;

        public PostParser(P1 parser, P2 postParser) {
            this.parser = (ParserFunction)Objects.requireNonNull(parser);
            this.postParser = (ParserFunction)Objects.requireNonNull(postParser);
        }

        @Override
        public Mono<T> parse(CommandContext context, R raw) throws InvalidArgumentException {
            return this.parser.parse(context, raw).flatMap(i -> this.postParser.parse(context, (Object)i));
        }
    }
}

