/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.context;

import dev.sympho.bot_utils.event.RepliableContext;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import reactor.core.publisher.Mono;

public interface CommandContext
extends RepliableContext {
    @Pure
    public Invocation invocation();

    @Pure
    public Invocation commandInvocation();

    @Pure
    default public User caller() {
        return this.user();
    }

    @Pure
    public @Nullable Member callerMember();

    @Pure
    default public Mono<Member> callerMember(Snowflake guildId) {
        return Objects.requireNonNullElse(this.callerMember(), this.caller()).asMember(guildId);
    }

    default public Mono<Member> member() {
        return Mono.justOrEmpty((Object)this.callerMember());
    }

    default public Mono<Member> member(Snowflake guildId) {
        return this.callerMember(guildId);
    }

    public Mono<MessageChannel> channel();

    @Pure
    public <T> @Nullable T getArgument(String var1, Class<T> var2) throws IllegalArgumentException, ClassCastException;

    @Pure
    default public <T> @Nullable T getArgument(Parameter<? extends T> parameter, Class<T> argumentType) throws IllegalArgumentException, ClassCastException {
        return this.getArgument(parameter.name(), argumentType);
    }

    @Pure
    public <T> @Nullable T getArgument(Parameter<? extends T> var1) throws IllegalArgumentException;

    @Pure
    default public <T> T requireArgument(String name, Class<T> argumentType) throws IllegalArgumentException, ClassCastException, NullPointerException {
        return Objects.requireNonNull(this.getArgument(name, argumentType));
    }

    @Pure
    default public <T> T requireArgument(Parameter<? extends T> parameter, Class<T> argumentType) throws IllegalArgumentException, ClassCastException, NullPointerException {
        return this.requireArgument(parameter.name(), argumentType);
    }

    @Pure
    default public <T> T requireArgument(Parameter<? extends T> parameter) throws IllegalArgumentException, NullPointerException {
        return Objects.requireNonNull(this.getArgument(parameter));
    }

    public boolean setContext(String var1, @Nullable Object var2, boolean var3);

    default public void setContext(String key, @Nullable Object obj) {
        this.setContext(key, obj, true);
    }

    @Pure
    public <T> @Nullable T getContext(String var1, Class<? extends T> var2) throws IllegalArgumentException, ClassCastException;

    @Pure
    default public <T> T requireContext(String key, Class<? extends T> type) throws IllegalArgumentException, ClassCastException, NullPointerException {
        return Objects.requireNonNull(this.getContext(key, type));
    }
}

