/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sympho.bot_utils.access.Group;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Command", generator="Immutables")
@Immutable
final class ImmutableCommand<H extends @NonNull Handlers>
implements Command<H> {
    private final String id;
    private final Command.Scope scope;
    private final boolean callable;
    private final Invocation parent;
    private final @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name;
    private final ImmutableSet<String> aliases;
    private final @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName;
    private final @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description;
    private final ImmutableList<Parameter<?>> parameters;
    private final Group requiredGroup;
    private final boolean skipGroupCheckOnInteraction;
    private final boolean requireParentGroups;
    private final boolean nsfw;
    private final boolean repliesDefaultPrivate;
    private final boolean deferReply;
    private final boolean inheritSettings;
    private final boolean invokeParent;
    private final H handlers;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCommand(Builder<H> builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.parameters = builder.parameters.build();
        this.handlers = builder.handlers;
        if (builder.scope != null) {
            this.initShim.scope(builder.scope);
        }
        if (builder.callableIsSet()) {
            this.initShim.callable(builder.callable);
        }
        if (builder.parent != null) {
            this.initShim.parent(builder.parent);
        }
        if (builder.aliasesIsSet()) {
            this.initShim.aliases((ImmutableSet<String>)builder.aliases.build());
        }
        if (builder.requiredGroup != null) {
            this.initShim.requiredGroup(builder.requiredGroup);
        }
        if (builder.skipGroupCheckOnInteractionIsSet()) {
            this.initShim.skipGroupCheckOnInteraction(builder.skipGroupCheckOnInteraction);
        }
        if (builder.requireParentGroupsIsSet()) {
            this.initShim.requireParentGroups(builder.requireParentGroups);
        }
        if (builder.nsfwIsSet()) {
            this.initShim.nsfw(builder.nsfw);
        }
        if (builder.repliesDefaultPrivateIsSet()) {
            this.initShim.repliesDefaultPrivate(builder.repliesDefaultPrivate);
        }
        if (builder.deferReplyIsSet()) {
            this.initShim.deferReply(builder.deferReply);
        }
        if (builder.inheritSettingsIsSet()) {
            this.initShim.inheritSettings(builder.inheritSettings);
        }
        if (builder.invokeParentIsSet()) {
            this.initShim.invokeParent(builder.invokeParent);
        }
        this.scope = this.initShim.scope();
        this.callable = this.initShim.callable();
        this.parent = this.initShim.parent();
        this.aliases = this.initShim.aliases();
        this.requiredGroup = this.initShim.requiredGroup();
        this.skipGroupCheckOnInteraction = this.initShim.skipGroupCheckOnInteraction();
        this.requireParentGroups = this.initShim.requireParentGroups();
        this.nsfw = this.initShim.nsfw();
        this.repliesDefaultPrivate = this.initShim.repliesDefaultPrivate();
        this.deferReply = this.initShim.deferReply();
        this.inheritSettings = this.initShim.inheritSettings();
        this.invokeParent = this.initShim.invokeParent();
        this.initShim = null;
    }

    private ImmutableCommand(String id, Command.Scope scope, boolean callable, Invocation parent, @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name, ImmutableSet<String> aliases, @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName, @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description, ImmutableList<Parameter<?>> parameters, Group requiredGroup, boolean skipGroupCheckOnInteraction, boolean requireParentGroups, boolean nsfw, boolean repliesDefaultPrivate, boolean deferReply, boolean inheritSettings, boolean invokeParent, H handlers) {
        this.id = id;
        this.scope = scope;
        this.callable = callable;
        this.parent = parent;
        this.name = name;
        this.aliases = aliases;
        this.displayName = displayName;
        this.description = description;
        this.parameters = parameters;
        this.requiredGroup = requiredGroup;
        this.skipGroupCheckOnInteraction = skipGroupCheckOnInteraction;
        this.requireParentGroups = requireParentGroups;
        this.nsfw = nsfw;
        this.repliesDefaultPrivate = repliesDefaultPrivate;
        this.deferReply = deferReply;
        this.inheritSettings = inheritSettings;
        this.invokeParent = invokeParent;
        this.handlers = handlers;
        this.initShim = null;
    }

    private Command.Scope scopeInitialize() {
        return Command.super.scope();
    }

    private boolean callableInitialize() {
        return Command.super.callable();
    }

    private Invocation parentInitialize() {
        return Command.super.parent();
    }

    private Set<String> aliasesInitialize() {
        return Command.super.aliases();
    }

    private Group requiredGroupInitialize() {
        return Command.super.requiredGroup();
    }

    private boolean skipGroupCheckOnInteractionInitialize() {
        return Command.super.skipGroupCheckOnInteraction();
    }

    private boolean requireParentGroupsInitialize() {
        return Command.super.requireParentGroups();
    }

    private boolean nsfwInitialize() {
        return Command.super.nsfw();
    }

    private boolean repliesDefaultPrivateInitialize() {
        return Command.super.repliesDefaultPrivate();
    }

    private boolean deferReplyInitialize() {
        return Command.super.deferReply();
    }

    private boolean inheritSettingsInitialize() {
        return Command.super.inheritSettings();
    }

    private boolean invokeParentInitialize() {
        return Command.super.invokeParent();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Command.Scope scope() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scope() : this.scope;
    }

    @Override
    public boolean callable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.callable() : this.callable;
    }

    @Override
    public Invocation parent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parent() : this.parent;
    }

    @Override
    public @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name() {
        return this.name;
    }

    public ImmutableSet<String> aliases() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aliases() : this.aliases;
    }

    @Override
    public @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName() {
        return this.displayName;
    }

    @Override
    public @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description() {
        return this.description;
    }

    @Override
    public ImmutableList<Parameter<?>> parameters() {
        return this.parameters;
    }

    @Override
    public Group requiredGroup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requiredGroup() : this.requiredGroup;
    }

    @Override
    public boolean skipGroupCheckOnInteraction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skipGroupCheckOnInteraction() : this.skipGroupCheckOnInteraction;
    }

    @Override
    public boolean requireParentGroups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requireParentGroups() : this.requireParentGroups;
    }

    @Override
    public boolean nsfw() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nsfw() : this.nsfw;
    }

    @Override
    public boolean repliesDefaultPrivate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.repliesDefaultPrivate() : this.repliesDefaultPrivate;
    }

    @Override
    public boolean deferReply() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deferReply() : this.deferReply;
    }

    @Override
    public boolean inheritSettings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inheritSettings() : this.inheritSettings;
    }

    @Override
    public boolean invokeParent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.invokeParent() : this.invokeParent;
    }

    @Override
    public H handlers() {
        return this.handlers;
    }

    public final ImmutableCommand<H> withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(newValue, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withScope(Command.Scope value) {
        Command.Scope newValue = Objects.requireNonNull(value, "scope");
        if (this.scope == newValue) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, newValue, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withCallable(boolean value) {
        if (this.callable == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, value, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withParent(Invocation value) {
        if (this.parent == value) {
            return this;
        }
        Invocation newValue = Objects.requireNonNull(value, "parent");
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, newValue, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withName(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String value) {
        @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, newValue, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withAliases(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, (ImmutableSet<String>)newValue, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withAliases(Iterable<String> elements) {
        if (this.aliases == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, (ImmutableSet<String>)newValue, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withDisplayName(@MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String value) {
        @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String newValue = Objects.requireNonNull(value, "displayName");
        if (this.displayName.equals(newValue)) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, newValue, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withDescription(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String value) {
        @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, newValue, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    @SafeVarargs
    public final ImmutableCommand<H> withParameters(Parameter<?> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, newValue, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withParameters(Iterable<? extends Parameter<?>> elements) {
        if (this.parameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, newValue, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withRequiredGroup(Group value) {
        if (this.requiredGroup == value) {
            return this;
        }
        Group newValue = Objects.requireNonNull(value, "requiredGroup");
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, newValue, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withSkipGroupCheckOnInteraction(boolean value) {
        if (this.skipGroupCheckOnInteraction == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, value, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withRequireParentGroups(boolean value) {
        if (this.requireParentGroups == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, value, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withNsfw(boolean value) {
        if (this.nsfw == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, value, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withRepliesDefaultPrivate(boolean value) {
        if (this.repliesDefaultPrivate == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, value, this.deferReply, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withDeferReply(boolean value) {
        if (this.deferReply == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, value, this.inheritSettings, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withInheritSettings(boolean value) {
        if (this.inheritSettings == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, value, this.invokeParent, this.handlers));
    }

    public final ImmutableCommand<H> withInvokeParent(boolean value) {
        if (this.invokeParent == value) {
            return this;
        }
        return ImmutableCommand.validate(new ImmutableCommand<H>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, value, this.handlers));
    }

    public final ImmutableCommand<H> withHandlers(H value) {
        if (this.handlers == value) {
            return this;
        }
        Handlers newValue = (Handlers)Objects.requireNonNull(value, "handlers");
        return ImmutableCommand.validate(new ImmutableCommand<Handlers>(this.id, this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.repliesDefaultPrivate, this.deferReply, this.inheritSettings, this.invokeParent, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommand && this.equalTo(0, (ImmutableCommand)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommand<?> another) {
        return this.id.equals(another.id) && this.scope.equals((Object)another.scope) && this.callable == another.callable && this.parent.equals(another.parent) && this.name.equals(another.name) && this.aliases.equals(another.aliases) && this.displayName.equals(another.displayName) && this.description.equals(another.description) && this.parameters.equals(another.parameters) && this.requiredGroup.equals(another.requiredGroup) && this.skipGroupCheckOnInteraction == another.skipGroupCheckOnInteraction && this.requireParentGroups == another.requireParentGroups && this.nsfw == another.nsfw && this.repliesDefaultPrivate == another.repliesDefaultPrivate && this.deferReply == another.deferReply && this.inheritSettings == another.inheritSettings && this.invokeParent == another.invokeParent && this.handlers.equals(another.handlers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.callable);
        h += (h << 5) + this.parent.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.aliases.hashCode();
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.parameters.hashCode();
        h += (h << 5) + this.requiredGroup.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.skipGroupCheckOnInteraction);
        h += (h << 5) + Booleans.hashCode((boolean)this.requireParentGroups);
        h += (h << 5) + Booleans.hashCode((boolean)this.nsfw);
        h += (h << 5) + Booleans.hashCode((boolean)this.repliesDefaultPrivate);
        h += (h << 5) + Booleans.hashCode((boolean)this.deferReply);
        h += (h << 5) + Booleans.hashCode((boolean)this.inheritSettings);
        h += (h << 5) + Booleans.hashCode((boolean)this.invokeParent);
        h += (h << 5) + this.handlers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Command").omitNullValues().add("id", (Object)this.id).add("scope", (Object)this.scope).add("callable", this.callable).add("parent", (Object)this.parent).add("name", (Object)this.name).add("aliases", this.aliases).add("displayName", (Object)this.displayName).add("description", (Object)this.description).add("parameters", this.parameters).add("requiredGroup", (Object)this.requiredGroup).add("skipGroupCheckOnInteraction", this.skipGroupCheckOnInteraction).add("requireParentGroups", this.requireParentGroups).add("nsfw", this.nsfw).add("repliesDefaultPrivate", this.repliesDefaultPrivate).add("deferReply", this.deferReply).add("inheritSettings", this.inheritSettings).add("invokeParent", this.invokeParent).add("handlers", this.handlers).toString();
    }

    private static <H extends Handlers> ImmutableCommand<H> validate(ImmutableCommand<H> instance) {
        instance.validate();
        return instance;
    }

    public static <H extends Handlers> Command<H> copyOf(Command<H> instance) {
        if (instance instanceof ImmutableCommand) {
            return (ImmutableCommand)instance;
        }
        return new Command.Builder<H>().from(instance).build();
    }

    @Generated(from="Command", generator="Immutables")
    private final class InitShim {
        private byte scopeBuildStage = 0;
        private Command.Scope scope;
        private byte callableBuildStage = 0;
        private boolean callable;
        private byte parentBuildStage = 0;
        private Invocation parent;
        private byte aliasesBuildStage = 0;
        private ImmutableSet<String> aliases;
        private byte requiredGroupBuildStage = 0;
        private Group requiredGroup;
        private byte skipGroupCheckOnInteractionBuildStage = 0;
        private boolean skipGroupCheckOnInteraction;
        private byte requireParentGroupsBuildStage = 0;
        private boolean requireParentGroups;
        private byte nsfwBuildStage = 0;
        private boolean nsfw;
        private byte repliesDefaultPrivateBuildStage = 0;
        private boolean repliesDefaultPrivate;
        private byte deferReplyBuildStage = 0;
        private boolean deferReply;
        private byte inheritSettingsBuildStage = 0;
        private boolean inheritSettings;
        private byte invokeParentBuildStage = 0;
        private boolean invokeParent;

        private InitShim() {
        }

        Command.Scope scope() {
            if (this.scopeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scopeBuildStage == 0) {
                this.scopeBuildStage = (byte)-1;
                this.scope = Objects.requireNonNull(ImmutableCommand.this.scopeInitialize(), "scope");
                this.scopeBuildStage = 1;
            }
            return this.scope;
        }

        void scope(Command.Scope scope) {
            this.scope = scope;
            this.scopeBuildStage = 1;
        }

        boolean callable() {
            if (this.callableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callableBuildStage == 0) {
                this.callableBuildStage = (byte)-1;
                this.callable = ImmutableCommand.this.callableInitialize();
                this.callableBuildStage = 1;
            }
            return this.callable;
        }

        void callable(boolean callable) {
            this.callable = callable;
            this.callableBuildStage = 1;
        }

        Invocation parent() {
            if (this.parentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parentBuildStage == 0) {
                this.parentBuildStage = (byte)-1;
                this.parent = Objects.requireNonNull(ImmutableCommand.this.parentInitialize(), "parent");
                this.parentBuildStage = 1;
            }
            return this.parent;
        }

        void parent(Invocation parent) {
            this.parent = parent;
            this.parentBuildStage = 1;
        }

        ImmutableSet<String> aliases() {
            if (this.aliasesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aliasesBuildStage == 0) {
                this.aliasesBuildStage = (byte)-1;
                this.aliases = ImmutableSet.copyOf(ImmutableCommand.this.aliasesInitialize());
                this.aliasesBuildStage = 1;
            }
            return this.aliases;
        }

        void aliases(ImmutableSet<String> aliases) {
            this.aliases = aliases;
            this.aliasesBuildStage = 1;
        }

        Group requiredGroup() {
            if (this.requiredGroupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requiredGroupBuildStage == 0) {
                this.requiredGroupBuildStage = (byte)-1;
                this.requiredGroup = Objects.requireNonNull(ImmutableCommand.this.requiredGroupInitialize(), "requiredGroup");
                this.requiredGroupBuildStage = 1;
            }
            return this.requiredGroup;
        }

        void requiredGroup(Group requiredGroup) {
            this.requiredGroup = requiredGroup;
            this.requiredGroupBuildStage = 1;
        }

        boolean skipGroupCheckOnInteraction() {
            if (this.skipGroupCheckOnInteractionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skipGroupCheckOnInteractionBuildStage == 0) {
                this.skipGroupCheckOnInteractionBuildStage = (byte)-1;
                this.skipGroupCheckOnInteraction = ImmutableCommand.this.skipGroupCheckOnInteractionInitialize();
                this.skipGroupCheckOnInteractionBuildStage = 1;
            }
            return this.skipGroupCheckOnInteraction;
        }

        void skipGroupCheckOnInteraction(boolean skipGroupCheckOnInteraction) {
            this.skipGroupCheckOnInteraction = skipGroupCheckOnInteraction;
            this.skipGroupCheckOnInteractionBuildStage = 1;
        }

        boolean requireParentGroups() {
            if (this.requireParentGroupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requireParentGroupsBuildStage == 0) {
                this.requireParentGroupsBuildStage = (byte)-1;
                this.requireParentGroups = ImmutableCommand.this.requireParentGroupsInitialize();
                this.requireParentGroupsBuildStage = 1;
            }
            return this.requireParentGroups;
        }

        void requireParentGroups(boolean requireParentGroups) {
            this.requireParentGroups = requireParentGroups;
            this.requireParentGroupsBuildStage = 1;
        }

        boolean nsfw() {
            if (this.nsfwBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nsfwBuildStage == 0) {
                this.nsfwBuildStage = (byte)-1;
                this.nsfw = ImmutableCommand.this.nsfwInitialize();
                this.nsfwBuildStage = 1;
            }
            return this.nsfw;
        }

        void nsfw(boolean nsfw) {
            this.nsfw = nsfw;
            this.nsfwBuildStage = 1;
        }

        boolean repliesDefaultPrivate() {
            if (this.repliesDefaultPrivateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.repliesDefaultPrivateBuildStage == 0) {
                this.repliesDefaultPrivateBuildStage = (byte)-1;
                this.repliesDefaultPrivate = ImmutableCommand.this.repliesDefaultPrivateInitialize();
                this.repliesDefaultPrivateBuildStage = 1;
            }
            return this.repliesDefaultPrivate;
        }

        void repliesDefaultPrivate(boolean repliesDefaultPrivate) {
            this.repliesDefaultPrivate = repliesDefaultPrivate;
            this.repliesDefaultPrivateBuildStage = 1;
        }

        boolean deferReply() {
            if (this.deferReplyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deferReplyBuildStage == 0) {
                this.deferReplyBuildStage = (byte)-1;
                this.deferReply = ImmutableCommand.this.deferReplyInitialize();
                this.deferReplyBuildStage = 1;
            }
            return this.deferReply;
        }

        void deferReply(boolean deferReply) {
            this.deferReply = deferReply;
            this.deferReplyBuildStage = 1;
        }

        boolean inheritSettings() {
            if (this.inheritSettingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inheritSettingsBuildStage == 0) {
                this.inheritSettingsBuildStage = (byte)-1;
                this.inheritSettings = ImmutableCommand.this.inheritSettingsInitialize();
                this.inheritSettingsBuildStage = 1;
            }
            return this.inheritSettings;
        }

        void inheritSettings(boolean inheritSettings) {
            this.inheritSettings = inheritSettings;
            this.inheritSettingsBuildStage = 1;
        }

        boolean invokeParent() {
            if (this.invokeParentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.invokeParentBuildStage == 0) {
                this.invokeParentBuildStage = (byte)-1;
                this.invokeParent = ImmutableCommand.this.invokeParentInitialize();
                this.invokeParentBuildStage = 1;
            }
            return this.invokeParent;
        }

        void invokeParent(boolean invokeParent) {
            this.invokeParent = invokeParent;
            this.invokeParentBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.scopeBuildStage == -1) {
                attributes.add("scope");
            }
            if (this.callableBuildStage == -1) {
                attributes.add("callable");
            }
            if (this.parentBuildStage == -1) {
                attributes.add("parent");
            }
            if (this.aliasesBuildStage == -1) {
                attributes.add("aliases");
            }
            if (this.requiredGroupBuildStage == -1) {
                attributes.add("requiredGroup");
            }
            if (this.skipGroupCheckOnInteractionBuildStage == -1) {
                attributes.add("skipGroupCheckOnInteraction");
            }
            if (this.requireParentGroupsBuildStage == -1) {
                attributes.add("requireParentGroups");
            }
            if (this.nsfwBuildStage == -1) {
                attributes.add("nsfw");
            }
            if (this.repliesDefaultPrivateBuildStage == -1) {
                attributes.add("repliesDefaultPrivate");
            }
            if (this.deferReplyBuildStage == -1) {
                attributes.add("deferReply");
            }
            if (this.inheritSettingsBuildStage == -1) {
                attributes.add("inheritSettings");
            }
            if (this.invokeParentBuildStage == -1) {
                attributes.add("invokeParent");
            }
            return "Cannot build Command, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="Command", generator="Immutables")
    @NotThreadSafe
    public static class Builder<H extends @NonNull Handlers> {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DISPLAY_NAME = 4L;
        private static final long INIT_BIT_DESCRIPTION = 8L;
        private static final long INIT_BIT_HANDLERS = 16L;
        private static final long OPT_BIT_CALLABLE = 1L;
        private static final long OPT_BIT_ALIASES = 2L;
        private static final long OPT_BIT_SKIP_GROUP_CHECK_ON_INTERACTION = 4L;
        private static final long OPT_BIT_REQUIRE_PARENT_GROUPS = 8L;
        private static final long OPT_BIT_NSFW = 16L;
        private static final long OPT_BIT_REPLIES_DEFAULT_PRIVATE = 32L;
        private static final long OPT_BIT_DEFER_REPLY = 64L;
        private static final long OPT_BIT_INHERIT_SETTINGS = 128L;
        private static final long OPT_BIT_INVOKE_PARENT = 256L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private Command.Scope scope;
        private boolean callable;
        @Nullable
        private Invocation parent;
        @Nullable
        private @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name;
        private ImmutableSet.Builder<String> aliases = ImmutableSet.builder();
        @Nullable
        private @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName;
        @Nullable
        private @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description;
        private ImmutableList.Builder<Parameter<?>> parameters = ImmutableList.builder();
        @Nullable
        private Group requiredGroup;
        private boolean skipGroupCheckOnInteraction;
        private boolean requireParentGroups;
        private boolean nsfw;
        private boolean repliesDefaultPrivate;
        private boolean deferReply;
        private boolean inheritSettings;
        private boolean invokeParent;
        @Nullable
        private H handlers;

        public Builder() {
            if (!(this instanceof Command.Builder)) {
                throw new UnsupportedOperationException("Use: new Command.Builder<H>()");
            }
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> from(Command<H> instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.scope(instance.scope());
            this.callable(instance.callable());
            this.parent(instance.parent());
            this.name(instance.name());
            this.addAllAliases(instance.aliases());
            this.displayName(instance.displayName());
            this.description(instance.description());
            this.addAllParameters(instance.parameters());
            this.requiredGroup(instance.requiredGroup());
            this.skipGroupCheckOnInteraction(instance.skipGroupCheckOnInteraction());
            this.requireParentGroups(instance.requireParentGroups());
            this.nsfw(instance.nsfw());
            this.repliesDefaultPrivate(instance.repliesDefaultPrivate());
            this.deferReply(instance.deferReply());
            this.inheritSettings(instance.inheritSettings());
            this.invokeParent(instance.invokeParent());
            this.handlers(instance.handlers());
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> scope(Command.Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> callable(boolean callable) {
            this.callable = callable;
            this.optBits |= 1L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> parent(Invocation parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> name(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> addAliases(String element) {
            this.aliases.add((Object)element);
            this.optBits |= 2L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> addAliases(String ... elements) {
            this.aliases.add((Object[])elements);
            this.optBits |= 2L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> aliases(Iterable<String> elements) {
            this.aliases = ImmutableSet.builder();
            return this.addAllAliases(elements);
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> addAllAliases(Iterable<String> elements) {
            this.aliases.addAll(elements);
            this.optBits |= 2L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> displayName(@MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> description(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> addParameters(Parameter<?> element) {
            this.parameters.add(element);
            return (Command.Builder)this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Command.Builder<H> addParameters(Parameter<?> ... elements) {
            this.parameters.add((Object[])elements);
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> parameters(Iterable<? extends Parameter<?>> elements) {
            this.parameters = ImmutableList.builder();
            return this.addAllParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> addAllParameters(Iterable<? extends Parameter<?>> elements) {
            this.parameters.addAll(elements);
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> requiredGroup(Group requiredGroup) {
            this.requiredGroup = Objects.requireNonNull(requiredGroup, "requiredGroup");
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> skipGroupCheckOnInteraction(boolean skipGroupCheckOnInteraction) {
            this.skipGroupCheckOnInteraction = skipGroupCheckOnInteraction;
            this.optBits |= 4L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> requireParentGroups(boolean requireParentGroups) {
            this.requireParentGroups = requireParentGroups;
            this.optBits |= 8L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> nsfw(boolean nsfw) {
            this.nsfw = nsfw;
            this.optBits |= 0x10L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> repliesDefaultPrivate(boolean repliesDefaultPrivate) {
            this.repliesDefaultPrivate = repliesDefaultPrivate;
            this.optBits |= 0x20L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> deferReply(boolean deferReply) {
            this.deferReply = deferReply;
            this.optBits |= 0x40L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> inheritSettings(boolean inheritSettings) {
            this.inheritSettings = inheritSettings;
            this.optBits |= 0x80L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> invokeParent(boolean invokeParent) {
            this.invokeParent = invokeParent;
            this.optBits |= 0x100L;
            return (Command.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Command.Builder<H> handlers(H handlers) {
            this.handlers = (Handlers)Objects.requireNonNull(handlers, "handlers");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (Command.Builder)this;
        }

        public Command<H> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCommand.validate(new ImmutableCommand(this));
        }

        private boolean callableIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean aliasesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean skipGroupCheckOnInteractionIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean requireParentGroupsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean nsfwIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean repliesDefaultPrivateIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean deferReplyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean inheritSettingsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean invokeParentIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("displayName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("handlers");
            }
            return "Cannot build Command, some of required attributes are not set " + attributes;
        }
    }
}

