/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command;

import dev.sympho.bot_utils.access.Group;
import dev.sympho.bot_utils.access.Groups;
import dev.sympho.modular_commands.api.command.ImmutableCommand;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.handler.InteractionHandlers;
import dev.sympho.modular_commands.api.command.handler.MessageHandlers;
import dev.sympho.modular_commands.api.command.handler.SlashHandlers;
import dev.sympho.modular_commands.api.command.handler.TextHandlers;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.utils.CommandUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE, overshadowImplementation=true)
public interface Command<H extends @NonNull Handlers> {
    public static final Scope DEFAULT_SCOPE = Scope.GLOBAL;
    public static final boolean DEFAULT_CALLABLE = true;
    public static final Group DEFAULT_GROUP = Groups.EVERYONE;
    public static final boolean DEFAULT_SKIP = true;
    public static final boolean DEFAULT_REQUIRE_PARENT_GROUPS = true;
    public static final boolean DEFAULT_NSFW = false;
    public static final boolean DEFAULT_PRIVATE = false;
    public static final boolean DEFAULT_DEFER = false;
    public static final boolean DEFAULT_INHERIT = false;
    public static final boolean DEFAULT_INVOKE_PARENT = false;
    public static final @Regex String NAME_REGEX = "(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$";
    public static final @Regex String DISPLAY_NAME_REGEX = "(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$";
    public static final @Regex String DESCRIPTION_REGEX = "(?Us)^.{1,100}+$";

    @Pure
    public String id();

    @Pure
    @Value.Default
    default public Scope scope() {
        return Scope.GLOBAL;
    }

    @Pure
    @Value.Default
    default public boolean callable() {
        return true;
    }

    @Pure
    @Value.Default
    default public Invocation parent() {
        return Invocation.EMPTY;
    }

    @Pure
    public @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name();

    @SideEffectFree
    @Value.NonAttribute
    default public Invocation invocation() {
        return this.parent().child(this.name());
    }

    @Pure
    @Value.Default
    default public Set<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> aliases() {
        return Collections.emptySet();
    }

    @SideEffectFree
    @Value.NonAttribute
    default public Set<Invocation> aliasInvocations() {
        return this.aliases().stream().map(this.parent()::child).collect(Collectors.toUnmodifiableSet());
    }

    @Pure
    public @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName();

    @Pure
    public @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description();

    @Pure
    public List<Parameter<?>> parameters();

    @Pure
    @Value.Default
    default public Group requiredGroup() {
        return DEFAULT_GROUP;
    }

    @Pure
    @Value.Default
    default public boolean skipGroupCheckOnInteraction() {
        return true;
    }

    @Pure
    @Value.Default
    default public boolean requireParentGroups() {
        return true;
    }

    @Pure
    @Value.Default
    default public boolean nsfw() {
        return false;
    }

    @Pure
    @Value.Default
    default public boolean repliesDefaultPrivate() {
        return false;
    }

    @Pure
    @Value.Default
    default public boolean deferReply() {
        return false;
    }

    @Pure
    @Value.Default
    default public boolean inheritSettings() {
        return false;
    }

    @Pure
    @Value.Default
    default public boolean invokeParent() {
        return false;
    }

    @Pure
    public H handlers();

    @Pure
    @Value.Check
    default public void validate() throws IllegalArgumentException, NullPointerException {
        CommandUtils.validateCommand(this);
    }

    @SideEffectFree
    public static <H extends Handlers> Builder<H> builder() {
        return new Builder();
    }

    @SideEffectFree
    public static <H extends Handlers> Builder<H> builder(Command<H> base) {
        return new Builder<H>().from(base);
    }

    @SideEffectFree
    public static Builder<MessageHandlers> message() {
        return Command.builder();
    }

    @SideEffectFree
    public static Builder<SlashHandlers> slash() {
        return Command.builder();
    }

    @SideEffectFree
    public static Builder<TextHandlers> text() {
        return Command.builder();
    }

    @SideEffectFree
    public static Builder<InteractionHandlers> interaction() {
        return Command.builder();
    }

    public static enum Scope {
        GLOBAL,
        GUILD;

    }

    public static class Builder<H extends @NonNull Handlers>
    extends ImmutableCommand.Builder<H> {
        public final Builder<H> parent(Command<?> parent) {
            return this.parent(Objects.requireNonNull(parent, "parent").invocation());
        }
    }
}

