package dev.sympho.modular_commands.execute;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sympho.bot_utils.access.AccessManager;
import dev.sympho.modular_commands.api.registry.Registry;
import discord4j.core.GatewayDiscordClient;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code MessageCommandExecutorBuilder} collects parameters and invokes the static factory method:
 * {@code new dev.sympho.modular_commands.execute.MessageCommandExecutor(..)}.
 * Call the {@link #build()} method to get a result of type {@code dev.sympho.modular_commands.execute.MessageCommandExecutor}.
 * <p><em>{@code MessageCommandExecutorBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "dev.sympho.modular_commands.execute.MessageCommandExecutor", generator = "Immutables")
@SuppressWarnings({"optional:optional.parameter", "all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class MessageCommandExecutorBuilder {
  private static final long INIT_BIT_CLIENT = 0x1L;
  private static final long INIT_BIT_REGISTRY = 0x2L;
  private static final long INIT_BIT_PREFIX_PROVIDER = 0x4L;
  private long initBits = 0x7L;

  private @Nullable GatewayDiscordClient client;
  private @Nullable Registry registry;
  private Optional<AccessManager> accessManager = Optional.empty();
  private Optional<MeterRegistry> meters = Optional.empty();
  private Optional<ObservationRegistry> observations = Optional.empty();
  private @Nullable PrefixProvider prefixProvider;
  private Optional<AliasProvider> aliases = Optional.empty();

  /**
   * Creates a {@code MessageCommandExecutorBuilder} factory builder.
   * <pre>
   * new MessageCommandExecutorBuilder()
   *    .client(discord4j.core.GatewayDiscordClient) // required {@code client}
   *    .registry(dev.sympho.modular_commands.api.registry.Registry) // required {@code registry}
   *    .accessManager(dev.sympho.bot_utils.access.AccessManager) // optional {@code accessManager}
   *    .meters(io.micrometer.core.instrument.MeterRegistry) // optional {@code meters}
   *    .observations(io.micrometer.observation.ObservationRegistry) // optional {@code observations}
   *    .prefixProvider(dev.sympho.modular_commands.execute.PrefixProvider) // required {@code prefixProvider}
   *    .aliases(dev.sympho.modular_commands.execute.AliasProvider) // optional {@code aliases}
   *    .build();
   * </pre>
   */
  public MessageCommandExecutorBuilder() {
  }

  /**
   * Initializes the value for the {@code client} attribute.
   * @param client The value for client 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder client(GatewayDiscordClient client) {
    this.client = Objects.requireNonNull(client, "client");
    initBits &= ~INIT_BIT_CLIENT;
    return this;
  }

  /**
   * Initializes the value for the {@code registry} attribute.
   * @param registry The value for registry 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder registry(Registry registry) {
    this.registry = Objects.requireNonNull(registry, "registry");
    initBits &= ~INIT_BIT_REGISTRY;
    return this;
  }

  /**
   * Initializes the optional value {@code accessManager} to accessManager.
   * @param accessManager The value for accessManager
   * @return {@code this} builder for chained invocation
   */
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder accessManager(AccessManager accessManager) {
    this.accessManager = Optional.of(accessManager);
    return this;
  }

  /**
   * Initializes the optional value {@code accessManager} to accessManager.
   * @param accessManager The value for accessManager
   * @return {@code this} builder for use in a chained invocation
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder accessManager(Optional<? extends AccessManager> accessManager) {
    this.accessManager = (Optional<AccessManager>) Objects.requireNonNull(accessManager, "accessManager");
    return this;
  }

  /**
   * Initializes the optional value {@code meters} to meters.
   * @param meters The value for meters
   * @return {@code this} builder for chained invocation
   */
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder meters(MeterRegistry meters) {
    this.meters = Optional.of(meters);
    return this;
  }

  /**
   * Initializes the optional value {@code meters} to meters.
   * @param meters The value for meters
   * @return {@code this} builder for use in a chained invocation
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder meters(Optional<? extends MeterRegistry> meters) {
    this.meters = (Optional<MeterRegistry>) Objects.requireNonNull(meters, "meters");
    return this;
  }

  /**
   * Initializes the optional value {@code observations} to observations.
   * @param observations The value for observations
   * @return {@code this} builder for chained invocation
   */
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder observations(ObservationRegistry observations) {
    this.observations = Optional.of(observations);
    return this;
  }

  /**
   * Initializes the optional value {@code observations} to observations.
   * @param observations The value for observations
   * @return {@code this} builder for use in a chained invocation
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder observations(Optional<? extends ObservationRegistry> observations) {
    this.observations = (Optional<ObservationRegistry>) Objects.requireNonNull(observations, "observations");
    return this;
  }

  /**
   * Initializes the value for the {@code prefixProvider} attribute.
   * @param prefixProvider The value for prefixProvider 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder prefixProvider(PrefixProvider prefixProvider) {
    this.prefixProvider = Objects.requireNonNull(prefixProvider, "prefixProvider");
    initBits &= ~INIT_BIT_PREFIX_PROVIDER;
    return this;
  }

  /**
   * Initializes the optional value {@code aliases} to aliases.
   * @param aliases The value for aliases
   * @return {@code this} builder for chained invocation
   */
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder aliases(AliasProvider aliases) {
    this.aliases = Optional.of(aliases);
    return this;
  }

  /**
   * Initializes the optional value {@code aliases} to aliases.
   * @param aliases The value for aliases
   * @return {@code this} builder for use in a chained invocation
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  @CanIgnoreReturnValue 
  public final MessageCommandExecutorBuilder aliases(Optional<? extends AliasProvider> aliases) {
    this.aliases = (Optional<AliasProvider>) Objects.requireNonNull(aliases, "aliases");
    return this;
  }

  /**
   * Invokes {@code new dev.sympho.modular_commands.execute.MessageCommandExecutor(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code dev.sympho.modular_commands.execute.MessageCommandExecutor}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public MessageCommandExecutor build() {
    checkRequiredAttributes();
    return new MessageCommandExecutor(client, registry, accessManager, meters, observations, prefixProvider, aliases);
  }

  private boolean clientIsSet() {
    return (initBits & INIT_BIT_CLIENT) == 0;
  }

  private boolean registryIsSet() {
    return (initBits & INIT_BIT_REGISTRY) == 0;
  }

  private boolean prefixProviderIsSet() {
    return (initBits & INIT_BIT_PREFIX_PROVIDER) == 0;
  }

  private void checkRequiredAttributes() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!clientIsSet()) attributes.add("client");
    if (!registryIsSet()) attributes.add("registry");
    if (!prefixProviderIsSet()) attributes.add("prefixProvider");
    return "Cannot build MessageCommandExecutor, some of required attributes are not set " + attributes;
  }
}
