/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import dev.sympho.modular_commands.utils.EmptyIterators;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;

public interface SmartIterator<E>
extends Iterator<E> {
    public static final String NO_MORE_ELEMENTS_ERROR = "No more elements";

    public static <E> Detachable<E> empty() {
        return EmptyIterators.EmptyDetachable.INSTANCE;
    }

    @Pure
    public @Nullable E peek();

    @SideEffectFree
    default public Spliterator<E> toSpliterator() {
        return Spliterators.spliteratorUnknownSize(this, 256);
    }

    @SideEffectFree
    default public Stream<E> toStream() {
        return StreamSupport.stream(this.toSpliterator(), false);
    }

    @SideEffectFree
    default public Flux<E> toFlux() {
        return Flux.fromStream(this.toStream());
    }

    @Override
    @EnsuresNonNullIf(expression={"peek()"}, result=true)
    default public boolean hasNext() {
        return this.peek() != null;
    }

    @SideEffectFree
    public static <E> SmartIterator<E> from(Iterator<E> backing) {
        return new Wrapper<E>(backing);
    }

    @SideEffectFree
    public static <E> Detachable<E> from(List<E> list) {
        return new ListIterator<E>(list);
    }

    public static class Wrapper<E>
    implements SmartIterator<E> {
        private final Iterator<E> backing;
        private @Nullable E next;

        public Wrapper(Iterator<E> backing) {
            this.backing = backing;
            this.next = backing.hasNext() ? backing.next() : null;
        }

        @Override
        public E next() throws NoSuchElementException {
            if (this.next != null) {
                E res = this.next;
                this.next = this.backing.hasNext() ? this.backing.next() : null;
                return res;
            }
            throw new NoSuchElementException(SmartIterator.NO_MORE_ELEMENTS_ERROR);
        }

        @Override
        public @Nullable E peek() {
            return this.next;
        }
    }

    public static class ListIterator<E>
    extends Wrapper<E>
    implements Detachable<E> {
        private final List<E> list;
        private int idx;

        public ListIterator(List<E> list) {
            super(list.iterator());
            this.list = list;
            this.idx = 0;
        }

        @SideEffectFree
        protected List<E> remaining() {
            return this.list.subList(this.idx, this.list.size());
        }

        @Override
        public E next() throws NoSuchElementException {
            Object res = super.next();
            ++this.idx;
            return res;
        }

        @Override
        public Detachable<E> toIterator() {
            return new ListIterator<E>(this.remaining());
        }

        @Override
        public Spliterator<E> toSpliterator() {
            return this.remaining().spliterator();
        }

        @Override
        public Stream<E> toStream() {
            return this.remaining().stream();
        }

        @Override
        public Flux<E> toFlux() {
            return Flux.fromIterable(this.remaining());
        }
    }

    public static interface Detachable<E>
    extends SmartIterator<E> {
        @SideEffectFree
        public Detachable<E> toIterator();

        @Override
        public Spliterator<E> toSpliterator();

        @Override
        public Stream<E> toStream();

        @Override
        public Flux<E> toFlux();
    }
}

