/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.netty.http.client.HttpClientResponse;

public final class HttpUtils {
    private HttpUtils() {
    }

    @SideEffectFree
    public static <E extends RuntimeException> Charset getCharset(HttpClientResponse response, Function<String, E> errorMapper) throws E {
        HttpResponseStatus status = response.status();
        if (status.codeClass() != HttpStatusClass.SUCCESS) {
            throw (RuntimeException)errorMapper.apply("Request failed: " + status);
        }
        String contentType = response.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return HttpUtil.getCharset((CharSequence)contentType);
    }

    @SideEffectFree
    public static Charset getCharset(HttpClientResponse response) throws IllegalStateException {
        return HttpUtils.getCharset(response, IllegalStateException::new);
    }
}

