/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.utils.ParameterUtils;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CommandUtils {
    private static final Pattern NAME_PATTERN = Pattern.compile("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$");
    private static final Pattern DISPLAY_NAME_PATTERN = Pattern.compile("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(?Us)^.{1,100}+$");

    private CommandUtils() {
    }

    @SideEffectFree
    public static void validateId(String id) throws NullPointerException {
        Objects.requireNonNull(id);
    }

    @SideEffectFree
    public static void validateParent(Invocation parent) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(parent, "Parent cannot be null.");
        parent.chain().forEach(CommandUtils::validateName);
    }

    @SideEffectFree
    public static void validateName(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(name, "Name cannot be null.");
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name.");
        }
        if (!name.equals(name.toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("Name must be all lowercase.");
        }
    }

    @SideEffectFree
    public static void validateAlias(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String alias) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(alias, "Alias cannot be null.");
        if (!NAME_PATTERN.matcher(alias).matches()) {
            throw new IllegalArgumentException("Invalid alias.");
        }
        if (!alias.equals(alias.toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("Alias must be all lowercase.");
        }
    }

    @SideEffectFree
    public static void validateAliases(Set<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> aliases) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(aliases, "Alias set cannot be null.").forEach(CommandUtils::validateAlias);
    }

    @SideEffectFree
    public static void validateDisplayName(@MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(name, "Display name cannot be null.");
        if (!DISPLAY_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid display name.");
        }
    }

    @SideEffectFree
    public static void validateDescription(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(description, "Description cannot be null.");
        if (!DESCRIPTION_PATTERN.matcher(description).matches()) {
            throw new IllegalArgumentException("Invalid description.");
        }
    }

    @SideEffectFree
    public static void validateParameters(List<Parameter<?>> parameters) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(parameters, "Parameter list cannot be null.");
        boolean optional = false;
        for (Parameter<?> p : parameters) {
            Objects.requireNonNull(p, "Parameter specification cannot be null.");
            ParameterUtils.validate(p);
            if (!p.required()) {
                optional = true;
                continue;
            }
            if (!optional) continue;
            throw new IllegalArgumentException("Required parameters must be before optional parameters.");
        }
        Stream<String> nameStream = parameters.stream().map(Parameter::name);
        ImmutableMultiset names = ImmutableMultiset.copyOf(nameStream.iterator());
        for (Multiset.Entry entry : names.entrySet()) {
            if (entry.getCount() <= 1) continue;
            throw new IllegalArgumentException(String.format("Duplicate parameter: %s", entry.getElement()));
        }
    }

    @SideEffectFree
    public static void validateGroup(Group group) throws NullPointerException {
        Objects.requireNonNull(group, "Required group cannot be null.");
    }

    @SideEffectFree
    public static void validateInvocationHandler(InvocationHandler<?> handler) throws NullPointerException {
        Objects.requireNonNull(handler, "Invocation handler cannot be null.");
    }

    @SideEffectFree
    public static void validateResultHandlers(List<? extends ResultHandler<?>> handlers) throws NullPointerException {
        Objects.requireNonNull(handlers, "Result handler list cannot be null.").forEach(h -> Objects.requireNonNull(h, "Result handler cannot be null."));
    }

    @SideEffectFree
    public static void validateHandlers(Handlers handlers) throws NullPointerException {
        CommandUtils.validateInvocationHandler(handlers.invocation());
        CommandUtils.validateResultHandlers(handlers.result());
    }

    @SideEffectFree
    public static void validateCommand(Command<?> command) throws IllegalArgumentException {
        CommandUtils.validateId(command.id());
        CommandUtils.validateName(command.name());
        CommandUtils.validateAliases(command.aliases());
        CommandUtils.validateDisplayName(command.displayName());
        CommandUtils.validateDescription(command.description());
        CommandUtils.validateParameters(command.parameters());
        CommandUtils.validateGroup(command.requiredGroup());
        CommandUtils.validateHandlers(command.handlers());
    }
}

