/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.BooleanParser;
import dev.sympho.modular_commands.api.command.parameter.parse.ChannelArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.FloatParser;
import dev.sympho.modular_commands.api.command.parameter.parse.IntegerParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.MessageArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.RoleArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.SnowflakeParser;
import dev.sympho.modular_commands.api.command.parameter.parse.StringParser;
import dev.sympho.modular_commands.api.command.parameter.parse.UserArgumentParser;
import dev.sympho.modular_commands.api.command.reply.CommandReplyMono;
import dev.sympho.modular_commands.api.command.reply.CommandReplySpec;
import dev.sympho.modular_commands.api.command.reply.Reply;
import dev.sympho.modular_commands.api.command.reply.ReplyManager;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentInvalid;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentMissing;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.Results;
import dev.sympho.modular_commands.api.exception.ResultException;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.execute.AccessManager;
import dev.sympho.modular_commands.execute.InstrumentedContext;
import dev.sympho.modular_commands.execute.LazyContext;
import dev.sympho.modular_commands.execute.Metrics;
import dev.sympho.modular_commands.utils.parse.ParseUtils;
import dev.sympho.reactor_utils.concurrent.ReactiveLatch;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import discord4j.core.spec.InteractionFollowupCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import io.micrometer.observation.ObservationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.observability.micrometer.Micrometer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class ContextImpl<A>
implements LazyContext,
InstrumentedContext {
    public static final String METRIC_NAME_PREFIX = "context";
    public static final String METRIC_NAME_PREFIX_ARGUMENT = "argument";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextImpl.class);
    private static final String METRIC_NAME_INITIALIZE = Metrics.name("context", "init");
    private static final String METRIC_NAME_LOAD = Metrics.name("context", "load");
    private static final String METRIC_NAME_ARGUMENT_INIT = Metrics.name("context", "argument", "init");
    private static final String METRIC_NAME_ARGUMENT_PARSE_ALL = Metrics.name("context", "argument", "all");
    private static final String METRIC_NAME_ARGUMENT_PARSE_ONE = Metrics.name("context", "argument", "one");
    private static final String METRIC_TAG_PARAMETER = Metrics.name("parameter");
    private static final String ERROR_NOT_INITIALIZED = "Not initialized yet";
    protected final Command<?> command;
    private final Invocation invocation;
    private final Map<String, @Nullable Object> context;
    private final AccessManager accessManager;
    private @MonotonicNonNull AccessValidator access;
    private @MonotonicNonNull Map<String, ? extends Argument<?>> arguments;
    private @MonotonicNonNull ReplyManager reply;
    private final AtomicBoolean initialized;
    private final ReactiveLatch initializeLatch;
    private @MonotonicNonNull Mono<CommandResult> loadResult;

    protected ContextImpl(Invocation invocation, Command<?> command, AccessManager accessManager) {
        this.command = command;
        this.invocation = invocation;
        this.accessManager = accessManager;
        this.context = new HashMap<String, Object>();
        this.access = null;
        this.arguments = null;
        this.reply = null;
        this.initialized = new AtomicBoolean(false);
        this.initializeLatch = new ReactiveLatch();
        this.loadResult = null;
    }

    protected abstract ReplyManager makeReplyManager();

    @SideEffectFree
    protected abstract Mono<String> getStringArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Boolean> getBooleanArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Long> getIntegerArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Double> getFloatArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Snowflake> getSnowflakeArgument(String var1, SnowflakeParser.Type var2) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<User> getUserArgument(String var1);

    @SideEffectFree
    protected abstract Mono<Role> getRoleArgument(String var1);

    @SideEffectFree
    protected abstract <C extends Channel> Mono<C> getChannelArgument(String var1, Class<C> var2);

    @SideEffectFree
    protected Mono<Message> getMessageArgument(String name) {
        return this.getStringArgument(name).flatMap(raw -> ParseUtils.MESSAGE.parse((CommandContext)this, (String)raw));
    }

    @SideEffectFree
    protected abstract Mono<Attachment> getAttachmentArgument(String var1);

    @SideEffectFree
    private <R> Mono<R> handleMissingArgument(Parameter<?> parameter) {
        if (parameter.required()) {
            return Mono.error(() -> new ResultException(new CommandFailureArgumentMissing(parameter)));
        }
        return Mono.empty();
    }

    @SideEffectFree
    private ResultException wrapInvalidParam(Parameter<?> parameter, InvalidArgumentException exception) {
        LOGGER.trace("Invalid argument for parameter {}: {}", parameter, (Object)exception.getMessage());
        String error = exception.getMessage();
        CommandFailureArgumentInvalid result = new CommandFailureArgumentInvalid(parameter, error);
        return new ResultException(result);
    }

    @SideEffectFree
    private ResultException wrapParamError(Parameter<?> parameter, Throwable error) {
        if (error instanceof ResultException) {
            ResultException res = (ResultException)error;
            LOGGER.warn("Result exception would be wrapped");
            return res;
        }
        LOGGER.error("Error while parsing parameter {}: {}", parameter, (Object)error.getMessage());
        return new ResultException(Results.exceptionR(error));
    }

    @SideEffectFree
    private <R, T> Mono<T> parseArgument(Parameter<T> parameter, Function<String, Mono<R>> getter, ArgumentParser<R, T> parser) {
        return getter.apply(parameter.name()).switchIfEmpty(this.handleMissingArgument(parameter)).map(parser::validateRaw).flatMap(raw -> parser.parse(this, raw)).switchIfEmpty(Mono.justOrEmpty(parameter.defaultValue())).onErrorMap(InvalidArgumentException.class, e -> this.wrapInvalidParam(parameter, (InvalidArgumentException)e)).onErrorMap(e -> !(e instanceof ResultException), e -> this.wrapParamError(parameter, (Throwable)e));
    }

    private <C extends Channel, T> Mono<T> parseArgument(Parameter<T> parameter, ChannelArgumentParser<C, T> parser) {
        return this.parseArgument(parameter, name -> this.getChannelArgument((String)name, parser.type()), parser);
    }

    @SideEffectFree
    private <T> Mono<T> parseArgument(Parameter<T> parameter) {
        ArgumentParser<?, T> parser = parameter.parser();
        if (parser instanceof AttachmentParser) {
            AttachmentParser p = (AttachmentParser)parser;
            return this.parseArgument(parameter, this::getAttachmentArgument, p);
        }
        if (parser instanceof StringParser) {
            StringParser p = (StringParser)parser;
            return this.parseArgument(parameter, this::getStringArgument, p);
        }
        if (parser instanceof BooleanParser) {
            BooleanParser p = (BooleanParser)parser;
            return this.parseArgument(parameter, this::getBooleanArgument, p);
        }
        if (parser instanceof IntegerParser) {
            IntegerParser p = (IntegerParser)parser;
            return this.parseArgument(parameter, this::getIntegerArgument, p);
        }
        if (parser instanceof FloatParser) {
            FloatParser p = (FloatParser)parser;
            return this.parseArgument(parameter, this::getFloatArgument, p);
        }
        if (parser instanceof SnowflakeParser) {
            SnowflakeParser p = (SnowflakeParser)parser;
            return this.parseArgument(parameter, n -> this.getSnowflakeArgument((String)n, p.type()), p);
        }
        if (parser instanceof UserArgumentParser) {
            UserArgumentParser p = (UserArgumentParser)parser;
            return this.parseArgument(parameter, this::getUserArgument, p);
        }
        if (parser instanceof RoleArgumentParser) {
            RoleArgumentParser p = (RoleArgumentParser)parser;
            return this.parseArgument(parameter, this::getRoleArgument, p);
        }
        if (parser instanceof ChannelArgumentParser) {
            ChannelArgumentParser p = (ChannelArgumentParser)parser;
            return this.parseArgument(parameter, p);
        }
        if (parser instanceof MessageArgumentParser) {
            MessageArgumentParser p = (MessageArgumentParser)parser;
            return this.parseArgument(parameter, this::getMessageArgument, p);
        }
        throw new IllegalArgumentException("Unrecognized parser type: " + parser.getClass());
    }

    @SideEffectFree
    private <T> Mono<? extends Map.Entry<String, ? extends Argument<T>>> processArgument(Parameter<T> parameter) {
        return this.parseArgument(parameter).singleOptional().map(v -> new Argument<Object>(parameter, v.orElse(null))).map(a -> Map.entry(parameter.name(), a)).doOnError(t -> {
            if (t instanceof ResultException) {
                ResultException ex = (ResultException)t;
                LOGGER.trace("Arg processing aborted: {}", (Object)ex.getResult());
            } else {
                LOGGER.error("Failed to process argument", t);
            }
        });
    }

    protected abstract Mono<Void> initArgs();

    @Override
    public String getCommandId() {
        return this.command.id();
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public Invocation getCommandInvocation() {
        return this.command.invocation();
    }

    @Pure
    private Argument<?> getArgument(String name) throws IllegalStateException, IllegalArgumentException {
        if (this.arguments == null) {
            throw new IllegalStateException("Context not loaded yet");
        }
        Argument<?> arg = this.arguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException(String.format("No parameter named '%s'", name));
        }
        return arg;
    }

    @Override
    public <T> @Nullable T getArgument(String name, Class<T> argumentType) throws IllegalArgumentException, ClassCastException {
        return this.getArgument(name).getValue(argumentType);
    }

    @Override
    public <T> @Nullable T getArgument(@FindDistinct Parameter<? extends T> parameter) throws IllegalArgumentException {
        Argument<?> argument = this.getArgument(parameter.name());
        if (argument.parameter() == parameter) {
            Argument<?> arg = argument;
            return (T)arg.value();
        }
        throw new IllegalArgumentException("Parameter does not match definition: " + parameter);
    }

    @Override
    public boolean setContext(String key, @Nullable Object obj, boolean replace) {
        if (!replace && this.context.containsKey(key)) {
            return false;
        }
        this.context.put(key, obj);
        return true;
    }

    @Override
    public <T> @Nullable T getContext(String key, Class<? extends T> type) throws IllegalArgumentException, ClassCastException {
        if (!this.context.containsKey(key)) {
            throw new IllegalArgumentException(String.format("No context under key '%s'.", key));
        }
        return type.cast(this.context.get(key));
    }

    @Override
    @Pure
    public ReplyManager replies() throws IllegalStateException {
        if (this.reply == null) {
            throw new IllegalStateException(ERROR_NOT_INITIALIZED);
        }
        return this.reply;
    }

    private AccessValidator getValidator() throws IllegalStateException {
        if (this.access == null) {
            throw new IllegalStateException(ERROR_NOT_INITIALIZED);
        }
        return this.access;
    }

    @Override
    public final Mono<Boolean> hasAccess(Group group) {
        return this.getValidator().hasAccess(group);
    }

    @Override
    public final Mono<CommandResult> validate(Group group) {
        return this.getValidator().validate(group);
    }

    private void doInitialize(ObservationRegistry observations) {
        LOGGER.trace("Initializing context");
        this.loadResult = Mono.just((Object)observations).flatMap(this::doLoad).cache();
        this.reply = new ReplyManagerWrapper(this.makeReplyManager());
        this.access = this.accessManager.validator(this);
        LOGGER.trace("Context initialized");
    }

    @Override
    public Mono<Void> initialize(ObservationRegistry observations) {
        if (this.initialized.getAndSet(true)) {
            return this.initializeLatch.await();
        }
        LOGGER.trace("Initializing context");
        this.loadResult = Mono.just((Object)observations).flatMap(this::doLoad).cache();
        this.reply = new ReplyManagerWrapper(this.makeReplyManager());
        return Mono.fromRunnable(() -> this.doInitialize(observations)).then().doOnSuccess(v -> this.initializeLatch.countDown()).doOnError(arg_0 -> ((ReactiveLatch)this.initializeLatch).fail(arg_0)).doOnError(t -> LOGGER.error("Failed to initialize", t)).checkpoint(METRIC_NAME_INITIALIZE).name(METRIC_NAME_INITIALIZE).transform(this::addTags).tap(Micrometer.observation((ObservationRegistry)observations)).cache();
    }

    public Mono<CommandResult> doLoad(ObservationRegistry observations) {
        LOGGER.trace("Loading context");
        Mono init = Mono.defer(() -> this.initArgs().checkpoint(METRIC_NAME_ARGUMENT_INIT).name(METRIC_NAME_ARGUMENT_INIT).transform(this::addTags).tap(Micrometer.observation((ObservationRegistry)observations)));
        Mono parse = Mono.defer(() -> Flux.fromIterable(this.command.parameters()).flatMap(p -> this.processArgument((Parameter)p).checkpoint(METRIC_NAME_ARGUMENT_PARSE_ONE).name(METRIC_NAME_ARGUMENT_PARSE_ONE).transform(this::addTags).tag(METRIC_TAG_PARAMETER, p.name()).tap(Micrometer.observation((ObservationRegistry)observations))).collectMap(Map.Entry::getKey, Map.Entry::getValue).doOnNext(args -> {
            this.arguments = args;
        }).checkpoint(METRIC_NAME_ARGUMENT_PARSE_ALL).name(METRIC_NAME_ARGUMENT_PARSE_ALL).transform(this::addTags).tap(Micrometer.observation((ObservationRegistry)observations)));
        return init.then(parse).checkpoint(METRIC_NAME_LOAD).name(METRIC_NAME_LOAD).transform(this::addTags).tap(Micrometer.observation((ObservationRegistry)observations)).doOnSuccess(v -> LOGGER.trace("Context loaded")).doOnError(t -> {
            if (t instanceof ResultException) {
                ResultException ex = (ResultException)t;
                LOGGER.trace("Load aborted: {}", (Object)ex.getResult());
            } else {
                LOGGER.error("Failed to load", t);
            }
        }).then(Mono.empty().cast(CommandResult.class)).onErrorResume(ResultException.class, e -> Mono.just((Object)e.getResult()));
    }

    @Override
    public Mono<CommandResult> load() {
        if (this.loadResult == null) {
            throw new IllegalStateException("Called load() before initialize()");
        }
        return this.loadResult;
    }

    private record Argument<T>(Parameter<T> parameter, @Nullable T value) {
        public <E> @Nullable E getValue(Class<E> argumentType) throws ClassCastException {
            return argumentType.cast(this.value);
        }
    }

    private static final class ReplyManagerWrapper
    implements ReplyManager {
        private final AtomicReference<ReplyManager> backing;

        ReplyManagerWrapper(ReplyManager backing) {
            this.backing = new AtomicReference<ReplyManager>(backing);
        }

        @Override
        public Mono<Reply> add(CommandReplySpec spec) {
            return this.backing.get().add(spec);
        }

        @Override
        public CommandReplyMono add() {
            return this.backing.get().add();
        }

        @Override
        public Mono<Reply> add(MessageCreateSpec spec) {
            return this.backing.get().add(spec);
        }

        @Override
        public Mono<Reply> add(InteractionApplicationCommandCallbackSpec spec) {
            return this.backing.get().add(spec);
        }

        @Override
        public Mono<Reply> add(InteractionFollowupCreateSpec spec) {
            return this.backing.get().add(spec);
        }

        @Override
        public Mono<Reply> add(String content) {
            return this.backing.get().add(content);
        }

        @Override
        public Mono<Reply> add(EmbedCreateSpec ... embeds) {
            return this.backing.get().add(embeds);
        }

        @Override
        public Reply get(int index) throws IndexOutOfBoundsException {
            return this.backing.get().get(index);
        }

        @Override
        public Reply get() throws IllegalStateException {
            return this.backing.get().get();
        }

        @Override
        public synchronized ReplyManager longTerm() {
            this.backing.updateAndGet(ReplyManager::longTerm);
            return this;
        }
    }
}

