/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import com.google.common.collect.Lists;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.exception.InvalidChainException;
import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.utils.SmartIterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public final class InvocationUtils {
    private InvocationUtils() {
    }

    @SideEffectFree
    public static <H extends Handlers> Tuple2<Invocation, List<Command<? extends H>>> parseInvocation(Registry registry, SmartIterator<String> args, Class<H> commandType) {
        String arg;
        Invocation next;
        Command<H> command;
        LinkedList<Command<H>> chain = new LinkedList<Command<H>>();
        Invocation current = Invocation.of(new String[0]);
        while (args.hasNext() && (command = registry.findCommand(next = current.child(arg = args.peek().toLowerCase(Locale.ROOT)), commandType)) != null) {
            chain.add(command);
            current = current.child(command.name());
            args.next();
        }
        return Tuples.of((Object)current, List.copyOf(chain));
    }

    @Pure
    public static <C extends Command<?>> C getInvokedCommand(List<? extends C> chain) {
        return (C)((Command)chain.get(chain.size() - 1));
    }

    @Pure
    public static <C extends Command<?>> C getSettingsSource(List<C> chain) {
        return (C)Lists.reverse(chain).stream().filter(Predicate.not(Command::inheritSettings)).findFirst().orElse((Command)chain.get(0));
    }

    @SideEffectFree
    public static List<Group> accumulateGroups(List<? extends Command<?>> chain) {
        long needParent = Lists.reverse(chain).stream().takeWhile(Command::requireParentGroups).count();
        long take = Math.min(needParent + 1L, (long)chain.size());
        return chain.stream().skip((long)chain.size() - take).map(Command::requiredGroup).toList();
    }

    private static boolean satisfied(Parameter<?> parameter) {
        return parameter.required() || parameter.defaultValue() != null;
    }

    @SideEffectFree
    public static <C extends Command<?>> List<C> handlingOrder(List<C> chain) {
        LinkedList<Command> commands = new LinkedList<Command>();
        ListIterator<C> it = chain.listIterator(chain.size());
        Command source = (Command)it.previous();
        commands.add(source);
        Command target = source;
        Set satisfiedParameters = source.parameters().stream().filter(InvocationUtils::satisfied).map(Parameter::name).collect(Collectors.toSet());
        Map<String, Class> parameterTypes = source.parameters().stream().collect(Collectors.toMap(Parameter::name, Object::getClass));
        while (it.hasPrevious() && source.invokeParent()) {
            source = (Command)it.previous();
            for (Parameter<?> p : source.parameters()) {
                Class receivedType = parameterTypes.get(p.name());
                if (receivedType != null && receivedType != p.getClass()) {
                    throw new InvalidChainException(source, target, String.format("Parameter %s is of type %s in parent but type %s in child", p.name(), p.getClass().getSimpleName(), receivedType.getSimpleName()));
                }
                if (!p.required() || satisfiedParameters.contains(p.name())) continue;
                throw new InvalidChainException(source, target, String.format("Parameter %s is required in parent but may not be present in child", p.name()));
            }
            commands.add(0, source);
        }
        return List.copyOf(commands);
    }

    @Pure
    public static <H extends Handlers> @Nullable Command<? extends H> checkType(Command<?> command, Class<H> type) {
        return type.isInstance(command.handlers()) ? command : null;
    }
}

