/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import dev.sympho.modular_commands.api.command.parameter.parse.ChoicesParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.dataflow.qual.Pure;

@FunctionalInterface
public interface StringParser<T>
extends ChoicesParser<String, T> {
    public static final int MAX_LENGTH = 6000;

    @Pure
    default public @IntRange(from=0L, to=6000L) @Nullable Integer minLength() {
        return null;
    }

    @Pure
    default public @IntRange(from=1L, to=6000L) @Nullable Integer maxLength() {
        return null;
    }

    @Pure
    default public boolean allowMerge() {
        return false;
    }

    @Pure
    default public String verifyLength(String raw) throws InvalidArgumentException {
        Integer min = this.minLength();
        Integer max = this.maxLength();
        int length = raw.length();
        if (min != null && length < min) {
            throw new InvalidArgumentException("Must have at least %d characters".formatted(min));
        }
        if (max != null && length > max) {
            throw new InvalidArgumentException("Must have at most %d characters".formatted(max));
        }
        return raw;
    }

    @Override
    default public String validateRaw(String raw) throws InvalidArgumentException {
        return this.verifyLength(ChoicesParser.super.validateRaw(raw));
    }
}

