/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Parameter", generator="Immutables")
@Immutable
final class ImmutableParameter<T>
implements Parameter<T> {
    private final @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name;
    private final @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description;
    private final boolean required;
    @Nullable
    private final T defaultValue;
    private final ArgumentParser<?, T> parser;

    private ImmutableParameter(Builder<T> builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.parser = builder.parser;
        this.required = builder.requiredIsSet() ? builder.required : Parameter.super.required();
    }

    private ImmutableParameter(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name, @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description, boolean required, @Nullable T defaultValue, ArgumentParser<?, T> parser) {
        this.name = name;
        this.description = description;
        this.required = required;
        this.defaultValue = defaultValue;
        this.parser = parser;
    }

    @Override
    public @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name() {
        return this.name;
    }

    @Override
    public @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description() {
        return this.description;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    @Nullable
    public T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public ArgumentParser<?, T> parser() {
        return this.parser;
    }

    public final ImmutableParameter<T> withName(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String value) {
        @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableParameter.validate(new ImmutableParameter<T>(newValue, this.description, this.required, this.defaultValue, this.parser));
    }

    public final ImmutableParameter<T> withDescription(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String value) {
        @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return ImmutableParameter.validate(new ImmutableParameter<T>(this.name, newValue, this.required, this.defaultValue, this.parser));
    }

    public final ImmutableParameter<T> withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return ImmutableParameter.validate(new ImmutableParameter<T>(this.name, this.description, value, this.defaultValue, this.parser));
    }

    public final ImmutableParameter<T> withDefaultValue(@Nullable T value) {
        if (this.defaultValue == value) {
            return this;
        }
        return ImmutableParameter.validate(new ImmutableParameter<T>(this.name, this.description, this.required, value, this.parser));
    }

    public final ImmutableParameter<T> withParser(ArgumentParser<?, T> value) {
        if (this.parser == value) {
            return this;
        }
        ArgumentParser<?, T> newValue = Objects.requireNonNull(value, "parser");
        return ImmutableParameter.validate(new ImmutableParameter<T>(this.name, this.description, this.required, this.defaultValue, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParameter && this.equalTo(0, (ImmutableParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableParameter<?> another) {
        return this.name.equals(another.name) && this.description.equals(another.description) && this.required == another.required && Objects.equals(this.defaultValue, another.defaultValue) && this.parser.equals(another.parser);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.required);
        h += (h << 5) + Objects.hashCode(this.defaultValue);
        h += (h << 5) + this.parser.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Parameter").omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("required", this.required).add("defaultValue", this.defaultValue).add("parser", this.parser).toString();
    }

    private static <T> ImmutableParameter<T> validate(ImmutableParameter<T> instance) {
        instance.validate();
        return instance;
    }

    public static <T> Parameter<T> copyOf(Parameter<T> instance) {
        if (instance instanceof ImmutableParameter) {
            return (ImmutableParameter)instance;
        }
        return new Parameter.Builder<T>().from(instance).build();
    }

    @Generated(from="Parameter", generator="Immutables")
    @NotThreadSafe
    public static class Builder<T> {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_PARSER = 4L;
        private static final long OPT_BIT_REQUIRED = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name;
        @Nullable
        private @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description;
        private boolean required;
        @Nullable
        private T defaultValue;
        @Nullable
        private ArgumentParser<?, T> parser;

        public Builder() {
            if (!(this instanceof Parameter.Builder)) {
                throw new UnsupportedOperationException("Use: new Parameter.Builder<T>()");
            }
        }

        @CanIgnoreReturnValue
        public final Parameter.Builder<T> from(Parameter<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.description(instance.description());
            this.required(instance.required());
            T defaultValueValue = instance.defaultValue();
            if (defaultValueValue != null) {
                this.defaultValue(defaultValueValue);
            }
            this.parser(instance.parser());
            return (Parameter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Parameter.Builder<T> name(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Parameter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Parameter.Builder<T> description(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Parameter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Parameter.Builder<T> required(boolean required) {
            this.required = required;
            this.optBits |= 1L;
            return (Parameter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Parameter.Builder<T> defaultValue(@Nullable T defaultValue) {
            this.defaultValue = defaultValue;
            return (Parameter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Parameter.Builder<T> parser(ArgumentParser<?, T> parser) {
            this.parser = Objects.requireNonNull(parser, "parser");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (Parameter.Builder)this;
        }

        public Parameter<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableParameter.validate(new ImmutableParameter(this));
        }

        private boolean requiredIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("parser");
            }
            return "Cannot build Parameter, some of required attributes are not set " + attributes;
        }
    }
}

