/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse.entity;

import dev.sympho.modular_commands.utils.parse.entity.EntityRef;
import dev.sympho.modular_commands.utils.parse.entity.EntityRefUrlParser;
import discord4j.common.util.Snowflake;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;

public class MessageRefUrlParser
extends EntityRefUrlParser<EntityRef.MessageRef> {
    private static final Pattern PATH_PATTERN = Pattern.compile("/channels/\\d++/(\\d++)/(\\d++)");

    @Override
    public String typeName() {
        return "message";
    }

    @Override
    protected boolean validPath(String path) {
        return PATH_PATTERN.matcher(path).matches();
    }

    @Override
    protected @Nullable EntityRef.MessageRef parsePath(String path) {
        Matcher match = PATH_PATTERN.matcher(path);
        if (!match.matches()) {
            return null;
        }
        String channelString = (String)NullnessUtil.castNonNull((Object)match.group(1));
        String messageString = (String)NullnessUtil.castNonNull((Object)match.group(2));
        Snowflake channelId = Snowflake.of((String)channelString);
        Snowflake messageId = Snowflake.of((String)messageString);
        return new EntityRef.MessageRef(messageId, channelId);
    }
}

