/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.utils.parse.UrlParser;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class UrlParserUtils {
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final List<String> PROTOCOL_HTTP_COMPATIBLE = List.of("http", "https");

    private UrlParserUtils() {
    }

    @Pure
    public static boolean isHttp(URL url) {
        return PROTOCOL_HTTP_COMPATIBLE.contains(url.getProtocol());
    }

    @Pure
    public static boolean isHttps(URL url) {
        return PROTOCOL_HTTPS.equals(url.getProtocol());
    }

    @Pure
    public static boolean isHost(URL url, String host) {
        return host.equals(url.getHost());
    }

    @Pure
    public static boolean isHost(URL url, Collection<String> aliases) {
        return aliases.contains(url.getHost());
    }

    @SideEffectFree
    public static <T, P extends UrlParser<T>> Function<URL, @Nullable P> toMapper(Collection<? extends P> parsers) {
        return url -> parsers.stream().filter(p -> p.supports((URL)url)).findFirst().orElse(null);
    }

    @Pure
    public static <T, P extends UrlParser<T>> Function<URL, @Nullable P> toHostMapper(Map<String, ? extends P> parsers) {
        return url -> (UrlParser)parsers.get(url.getHost());
    }
}

