/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import dev.sympho.modular_commands.utils.EmptyIterators;
import dev.sympho.modular_commands.utils.SmartIterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

public interface StringSplitter
extends Function<String, List<String>> {
    @SideEffectFree
    public List<String> split(String var1);

    @Pure
    public String delimiter();

    @Override
    default public List<String> apply(String raw) {
        return this.split(raw);
    }

    @SideEffectFree
    default public Iterator iterate(String raw) {
        class BaseIterator
        extends SmartIterator.ListIterator<String>
        implements Iterator {
            BaseIterator(List<String> parsed) {
                super(parsed);
            }

            @Override
            public StringSplitter splitter() {
                return StringSplitter.this;
            }

            @Override
            public Iterator toIterator() {
                return new BaseIterator(this.remaining());
            }
        }
        return new BaseIterator(this.split(raw));
    }

    @SideEffectFree
    default public Iterator emptyIterator() {
        return new EmptyIterators.EmptySplitter<StringSplitter>(this);
    }

    public static class Shell
    implements Async {
        @Override
        public String delimiter() {
            return " ";
        }

        @Pure
        private static int nextWhitespace(String value) {
            for (int i = 0; i < value.length(); ++i) {
                if (!Character.isWhitespace(value.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        @Pure
        private static int nextClose(String value, Character delim) {
            int cur = 1;
            while (cur >= 0) {
                cur = value.indexOf(delim.charValue(), cur);
                if (cur < 0 || cur != value.length() - 1 && !Character.isWhitespace(value.charAt(cur + 1))) continue;
                return cur;
            }
            return -1;
        }

        @Override
        public String takeNext(String state, Consumer<String> sink) {
            int nextStart;
            int endIdx;
            String current = state.trim();
            if (current.isEmpty()) {
                return current;
            }
            int startIdx = 1;
            if (current.startsWith("\"")) {
                endIdx = Shell.nextClose(current, Character.valueOf('\"'));
            } else if (current.startsWith("'")) {
                endIdx = Shell.nextClose(current, Character.valueOf('\''));
            } else {
                startIdx = 0;
                endIdx = Shell.nextWhitespace(current);
            }
            if (endIdx < 0) {
                startIdx = 0;
                endIdx = current.length();
                nextStart = current.length();
            } else {
                nextStart = endIdx + 1;
            }
            sink.accept(current.substring(startIdx, endIdx));
            return current.substring(nextStart).trim();
        }
    }

    public static interface Async
    extends StringSplitter {
        public String takeNext(String var1, Consumer<String> var2);

        @Override
        default public List<String> split(String raw) {
            LinkedList components = new LinkedList();
            while (!raw.isEmpty()) {
                raw = this.takeNext(raw, components::add);
            }
            return List.copyOf(components);
        }

        @SideEffectFree
        default public Flux<String> splitAsync(String raw) {
            return Flux.generate(() -> raw, (state, sink) -> {
                if (state.isEmpty()) {
                    sink.complete();
                    return "";
                }
                return this.takeNext((String)state, arg_0 -> ((SynchronousSink)sink).next(arg_0));
            });
        }

        @Override
        default public Iterator iterate(final String raw) {
            return new Iterator(){
                private final AtomicReference<@Nullable String> next = new AtomicReference();
                private String state = raw;
                private String nextState = this.takeNext(raw, this.next::set);

                @Override
                public String remainder() {
                    return this.state;
                }

                @Override
                public String next() throws NoSuchElementException {
                    String n = this.next.getAndSet(null);
                    if (n == null) {
                        throw new NoSuchElementException("No more elements");
                    }
                    this.state = this.nextState;
                    this.nextState = this.takeNext(this.state, this.next::set);
                    return n;
                }

                @Override
                public @Nullable String peek() {
                    return this.next.get();
                }

                @Override
                public Iterator toIterator() {
                    return this.iterate(this.state);
                }

                @Override
                public Spliterator<String> toSpliterator() {
                    return this.spliterate(this.state);
                }

                @Override
                public Stream<String> toStream() {
                    return this.splitStream(this.state);
                }

                @Override
                public Flux<String> toFlux() {
                    return this.splitAsync(this.state);
                }

                @Override
                public Async splitter() {
                    return this;
                }
            };
        }

        @SideEffectFree
        default public Spliterator<String> spliterate(String raw) {
            return Spliterators.spliteratorUnknownSize(this.iterate(raw), 1296);
        }

        @SideEffectFree
        default public Stream<String> splitStream(String raw) {
            return StreamSupport.stream(this.spliterate(raw), false);
        }

        @Override
        default public Iterator emptyIterator() {
            return new EmptyIterators.EmptyAsyncSplitter<Async>(this);
        }

        public static interface Iterator
        extends dev.sympho.modular_commands.utils.StringSplitter$Iterator {
            @Pure
            public String remainder();

            @Override
            public Async splitter();

            @Override
            public Iterator toIterator();
        }
    }

    public static interface Iterator
    extends SmartIterator.Detachable<String> {
        @Pure
        public StringSplitter splitter();

        public Iterator toIterator();
    }
}

