/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.ListUtils;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Metrics {
    public static final String PREFIX = "command";

    private Metrics() {
    }

    public static String name(String ... components) {
        return String.join((CharSequence)".", ListUtils.union(List.of(PREFIX), Arrays.asList(components)));
    }

    public static interface Tag {
        @Pure
        public String key();

        @Pure
        public String value();

        @SideEffectFree
        default public <T> Mono<T> apply(Mono<T> mono) {
            return mono.tag(this.key(), this.value());
        }

        @SideEffectFree
        default public <T> Flux<T> apply(Flux<T> flux) {
            return flux.tag(this.key(), this.value());
        }

        public record CommandId(String id) implements Tag
        {
            private static final String NAME = Metrics.name("id");

            public CommandId(String id) {
                this.id = Objects.requireNonNull(id);
            }

            public static CommandId from(String id) {
                return new CommandId(id);
            }

            @Override
            public String key() {
                return NAME;
            }

            @Override
            public String value() {
                return this.id;
            }
        }

        public static enum Type implements Tag
        {
            MESSAGE,
            SLASH;

            private static final String NAME;

            @Override
            public String key() {
                return NAME;
            }

            @Override
            public String value() {
                return this.name().toLowerCase();
            }

            static {
                NAME = Metrics.name("type");
            }
        }
    }
}

