/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.utils.StringSplitter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface AliasProvider
extends UnaryOperator<StringSplitter.Async.Iterator> {
    @Override
    public StringSplitter.Async.Iterator apply(StringSplitter.Async.Iterator var1);

    public static AliasProvider of(Collection<? extends Map.Entry<Invocation, Invocation>> aliases) {
        Map<Invocation, Invocation> map = aliases.stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        return iter -> {
            Invocation next;
            Object alias;
            Invocation current = Invocation.of(new String[0]);
            @Nullable Invocation result = null;
            while (iter.hasNext() && (alias = (Invocation)map.get(next = current.child((String)iter.peek()))) != null) {
                current = next;
                result = alias;
                iter.next();
            }
            if (result == null) {
                return iter;
            }
            LoggerFactory.getLogger(AliasProvider.class).debug("Applying alias from {} to {}", (Object)current, result);
            StringSplitter.Async splitter = iter.splitter();
            alias = String.join((CharSequence)splitter.delimiter(), result.chain());
            String aliased = String.join((CharSequence)splitter.delimiter(), new CharSequence[]{alias, iter.remainder()});
            return splitter.iterate(aliased);
        };
    }

    public static AliasProvider of(Map<Invocation, Invocation> aliases) {
        return AliasProvider.of(aliases.entrySet());
    }

    @SafeVarargs
    public static AliasProvider of(Map.Entry<Invocation, Invocation> ... aliases) {
        return AliasProvider.of(Arrays.asList(aliases));
    }

    public static AliasProvider none() {
        return iter -> iter;
    }
}

