/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.registry;

import dev.sympho.modular_commands.api.CommandGroup;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Registry {
    @Pure
    public <H extends Handlers> @Nullable Command<? extends H> findCommand(Invocation var1, Class<H> var2);

    @SideEffectFree
    public <H extends Handlers> Collection<Command<? extends H>> getCommands(Class<H> var1);

    @Pure
    public @Nullable Command<?> getCommand(String var1);

    public boolean registerCommand(Command<?> var1) throws IllegalArgumentException;

    default public void registerCommands(Collection<? extends Command<?>> commands) {
        Logger logger = LoggerFactory.getLogger(Registry.class);
        commands.forEach(c -> {
            try {
                if (!this.registerCommand((Command<?>)c)) {
                    logger.error("Command {} could not be added due to using an existing ID", (Object)c.id());
                }
            }
            catch (IllegalArgumentException e) {
                logger.error(String.format("Command %s could not be added due to being invalid", c.id()), (Throwable)e);
            }
        });
    }

    default public void registerCommands(CommandGroup commands) {
        this.registerCommands(commands.commands());
    }

    default public void registerCommands(Command<?> ... commands) {
        this.registerCommands(Arrays.asList(commands));
    }

    public @Nullable Command<?> removeCommand(String var1);
}

