/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.reply;

import dev.sympho.modular_commands.api.command.reply.CommandReplyMono;
import dev.sympho.modular_commands.api.command.reply.CommandReplySpec;
import dev.sympho.modular_commands.api.command.reply.CommandReplySpecGenerator;
import dev.sympho.modular_commands.api.command.reply.Reply;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import discord4j.core.spec.InteractionFollowupCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import java.util.Arrays;
import reactor.core.publisher.Mono;

public interface ReplyManager {
    public static final String NO_RESPONSE_ERROR = "No response made yet.";

    public Mono<Reply> add(CommandReplySpec var1);

    default public CommandReplyMono add() {
        return CommandReplyMono.of(this);
    }

    default public Mono<Reply> add(MessageCreateSpec spec) {
        return this.add(CommandReplySpecGenerator.from(spec));
    }

    default public Mono<Reply> add(InteractionApplicationCommandCallbackSpec spec) {
        return this.add(CommandReplySpecGenerator.from(spec));
    }

    default public Mono<Reply> add(InteractionFollowupCreateSpec spec) {
        return this.add(CommandReplySpecGenerator.from(spec));
    }

    default public Mono<Reply> add(String content) {
        CommandReplySpec spec = CommandReplySpec.builder().content(content).build();
        return this.add(spec);
    }

    default public Mono<Reply> add(EmbedCreateSpec ... embeds) {
        CommandReplySpec spec = CommandReplySpec.builder().embeds(Arrays.asList(embeds)).build();
        return this.add(spec);
    }

    public Reply get(int var1) throws IndexOutOfBoundsException;

    default public Reply get() throws IllegalStateException {
        try {
            return this.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(NO_RESPONSE_ERROR);
        }
    }

    public ReplyManager longTerm();
}

