/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.reply;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sympho.modular_commands.api.command.reply.CommandReplyEditSpecGenerator;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommandReplyEditSpecGenerator", generator="Immutables")
@Immutable
public final class CommandReplyEditSpec
implements CommandReplyEditSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final ImmutableList<MessageCreateFields.File> files;
    private final ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private final List<Attachment> attachments_value;
    private final boolean attachments_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private CommandReplyEditSpec(Possible<Optional<String>> content, Possible<Optional<List<EmbedCreateSpec>>> embeds, ImmutableList<MessageCreateFields.File> files, ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<Optional<AllowedMentions>> allowedMentions, Possible<Optional<List<LayoutComponent>>> components, Possible<Optional<List<Attachment>>> attachments) {
        Possible<Optional<String>> content$impl = content;
        Possible<Optional<List<EmbedCreateSpec>>> embeds$impl = embeds;
        this.files = files;
        this.fileSpoilers = fileSpoilers;
        Possible<Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
        Possible<Optional<List<LayoutComponent>>> components$impl = components;
        Possible<Optional<List<Attachment>>> attachments$impl = attachments;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = Possible.flatOpt(components$impl).orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<Optional<String>> content() {
        return this.content_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.content_value));
    }

    @Override
    public Possible<Optional<List<EmbedCreateSpec>>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_value));
    }

    @Override
    public List<MessageCreateFields.File> files() {
        return this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return this.fileSpoilers;
    }

    @Override
    public Possible<Optional<AllowedMentions>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.allowedMentions_value));
    }

    @Override
    public Possible<Optional<List<LayoutComponent>>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.components_value));
    }

    @Override
    public Possible<Optional<List<Attachment>>> attachments() {
        return this.attachments_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_value));
    }

    public CommandReplyEditSpec withContent(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new CommandReplyEditSpec(newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    @Deprecated
    public CommandReplyEditSpec withContent(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new CommandReplyEditSpec((Possible<Optional<String>>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    public CommandReplyEditSpec withContentOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new CommandReplyEditSpec((Possible<Optional<String>>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    public CommandReplyEditSpec withEmbeds(Possible<Optional<List<EmbedCreateSpec>>> possible) {
        Possible<Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
        return new CommandReplyEditSpec(this.content(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    @Deprecated
    public CommandReplyEditSpec withEmbeds(@Nullable Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new CommandReplyEditSpec(this.content(), (Possible<Optional<List<EmbedCreateSpec>>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    public CommandReplyEditSpec withEmbedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new CommandReplyEditSpec(this.content(), (Possible<Optional<List<EmbedCreateSpec>>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    @SafeVarargs
    public final CommandReplyEditSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return new CommandReplyEditSpec(this.content(), (Possible<Optional<List<EmbedCreateSpec>>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    public CommandReplyEditSpec withFiles(MessageCreateFields.File ... elements) {
        ImmutableList<MessageCreateFields.File> newValue = this.with_withFiles(elements);
        if (this.files == newValue) {
            return this;
        }
        return new CommandReplyEditSpec(this.content(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    private ImmutableList<MessageCreateFields.File> with_withFiles(MessageCreateFields.File ... elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.File f : elements) {
            fs.add((Object)CommandReplyEditSpec.files_copy(f));
        }
        return fs.build();
    }

    public CommandReplyEditSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        ImmutableList<MessageCreateFields.File> newValue = this.with_withFiles(elements);
        if (this.files == newValue) {
            return this;
        }
        return new CommandReplyEditSpec(this.content(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components(), this.attachments());
    }

    private ImmutableList<MessageCreateFields.File> with_withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.File file : elements) {
            fs.add((Object)CommandReplyEditSpec.files_copy(file));
        }
        return fs.build();
    }

    public CommandReplyEditSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        ImmutableList<MessageCreateFields.FileSpoiler> newValue = this.with_withFileSpoilers(elements);
        if (this.fileSpoilers == newValue) {
            return this;
        }
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components(), this.attachments());
    }

    private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.FileSpoiler f : elements) {
            fs.add((Object)CommandReplyEditSpec.fileSpoilers_copy(f));
        }
        return fs.build();
    }

    public CommandReplyEditSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        ImmutableList<MessageCreateFields.FileSpoiler> newValue = this.with_withFileSpoilers(elements);
        if (this.fileSpoilers == newValue) {
            return this;
        }
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components(), this.attachments());
    }

    private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
            fs.add((Object)CommandReplyEditSpec.fileSpoilers_copy(fileSpoiler));
        }
        return fs.build();
    }

    public CommandReplyEditSpec withAllowedMentions(Possible<Optional<AllowedMentions>> value) {
        Possible<Optional<AllowedMentions>> newValue = Objects.requireNonNull(value);
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components(), this.attachments());
    }

    @Deprecated
    public CommandReplyEditSpec withAllowedMentions(@Nullable AllowedMentions value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, (Possible<Optional<AllowedMentions>>)newValue, this.components(), this.attachments());
    }

    public CommandReplyEditSpec withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, (Possible<Optional<AllowedMentions>>)newValue, this.components(), this.attachments());
    }

    public CommandReplyEditSpec withComponents(Possible<Optional<List<LayoutComponent>>> possible) {
        Possible<Optional<List<LayoutComponent>>> newValue = Objects.requireNonNull(possible);
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.attachments());
    }

    @Deprecated
    public CommandReplyEditSpec withComponents(@Nullable Iterable<LayoutComponent> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Optional<List<LayoutComponent>>>)newValue, this.attachments());
    }

    public CommandReplyEditSpec withComponentsOrNull(@Nullable Iterable<LayoutComponent> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Optional<List<LayoutComponent>>>)newValue, this.attachments());
    }

    @SafeVarargs
    public final CommandReplyEditSpec withComponents(LayoutComponent ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Optional<List<LayoutComponent>>>)newValue, this.attachments());
    }

    public CommandReplyEditSpec withAttachments(Possible<Optional<List<Attachment>>> possible) {
        Possible<Optional<List<Attachment>>> newValue = Objects.requireNonNull(possible);
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), newValue);
    }

    @Deprecated
    public CommandReplyEditSpec withAttachments(@Nullable Iterable<Attachment> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), (Possible<Optional<List<Attachment>>>)newValue);
    }

    public CommandReplyEditSpec withAttachmentsOrNull(@Nullable Iterable<Attachment> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), (Possible<Optional<List<Attachment>>>)newValue);
    }

    @SafeVarargs
    public final CommandReplyEditSpec withAttachments(Attachment ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return new CommandReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), (Possible<Optional<List<Attachment>>>)newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CommandReplyEditSpec && this.equalTo(0, (CommandReplyEditSpec)another);
    }

    private boolean equalTo(int synthetic, CommandReplyEditSpec another) {
        return this.content().equals(another.content()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files().equals(another.files()) && this.fileSpoilers().equals(another.fileSpoilers()) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value) && Objects.equals(this.attachments_value, another.attachments_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files().hashCode();
        h += (h << 5) + this.fileSpoilers().hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + Objects.hashCode(this.attachments_value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommandReplyEditSpec").omitNullValues().add("content", (Object)this.content().toString()).add("embeds", (Object)Objects.toString(this.embeds_value)).add("files", (Object)this.files().toString()).add("fileSpoilers", (Object)this.fileSpoilers().toString()).add("allowedMentions", (Object)this.allowedMentions().toString()).add("components", (Object)Objects.toString(this.components_value)).add("attachments", (Object)Objects.toString(this.attachments_value)).toString();
    }

    static CommandReplyEditSpec copyOf(CommandReplyEditSpecGenerator instance) {
        if (instance instanceof CommandReplyEditSpec) {
            return (CommandReplyEditSpec)instance;
        }
        return CommandReplyEditSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    private static ImmutableList<MessageCreateFields.File> files_of(Collection<? extends MessageCreateFields.File> input) {
        ImmutableList.Builder fs = ImmutableList.builder();
        input.stream().map(f -> CommandReplyEditSpec.files_copy(f)).forEach(arg_0 -> ((ImmutableList.Builder)fs).add(arg_0));
        return fs.build();
    }

    private static ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_of(Collection<? extends MessageCreateFields.FileSpoiler> input) {
        ImmutableList.Builder fs = ImmutableList.builder();
        input.stream().map(f -> CommandReplyEditSpec.fileSpoilers_copy(f)).forEach(arg_0 -> ((ImmutableList.Builder)fs).add(arg_0));
        return fs.build();
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isAttachmentsPresent() {
        return !this.attachments_absent;
    }

    public List<Attachment> attachmentsOrElse(List<Attachment> defaultValue) {
        return !this.attachments_absent ? this.attachments_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static MessageCreateFields.File files_copy(MessageCreateFields.File file) {
        return MessageCreateFields.File.of((String)file.name(), (InputStream)file.inputStream());
    }

    private static MessageCreateFields.FileSpoiler fileSpoilers_copy(MessageCreateFields.FileSpoiler file) {
        return MessageCreateFields.FileSpoiler.of((String)file.name(), (InputStream)file.inputStream());
    }

    @Generated(from="CommandReplyEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build CommandReplyEditSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="CommandReplyEditSpecGenerator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Possible<Optional<String>> content_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private boolean embeds_explicitNull;
        private ImmutableList.Builder<MessageCreateFields.File> files_list = ImmutableList.builder();
        private ImmutableList.Builder<MessageCreateFields.FileSpoiler> fileSpoilers_list = ImmutableList.builder();
        private Possible<Optional<AllowedMentions>> allowedMentions_possible = Possible.absent();
        private List<LayoutComponent> components_list = null;
        private boolean components_explicitNull;
        private List<Attachment> attachments_list = null;
        private boolean attachments_explicitNull;

        private Builder() {
        }

        public final Builder from(CommandReplyEditSpec instance) {
            return this.from((CommandReplyEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(CommandReplyEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.embeds(instance.embeds());
            this.files(instance.files());
            this.fileSpoilers(instance.fileSpoilers());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            this.attachments(instance.attachments());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<Optional<String>> value) {
            this.content_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder content(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder contentOrNull(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            this.embeds_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Possible<Optional<List<EmbedCreateSpec>>> elements) {
            this.embeds_list = null;
            this.embeds_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.embeds_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.embeds_explicitNull = true;
                }
            });
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder embeds(@Nullable Iterable<EmbedCreateSpec> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder files(Iterable<? extends MessageCreateFields.File> files) {
            this.files_list = ImmutableList.builder();
            files.forEach(f -> this.files_list.add((Object)CommandReplyEditSpec.files_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFile(MessageCreateFields.File ... files) {
            Arrays.asList(files).forEach(f -> this.files_list.add((Object)CommandReplyEditSpec.files_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFiles(Iterable<? extends MessageCreateFields.File> files) {
            files.forEach(f -> this.files_list.add((Object)CommandReplyEditSpec.files_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
            this.fileSpoilers_list = ImmutableList.builder();
            files.forEach(f -> this.fileSpoilers_list.add((Object)CommandReplyEditSpec.fileSpoilers_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFileSpoiler(MessageCreateFields.FileSpoiler ... files) {
            Arrays.asList(files).forEach(f -> this.fileSpoilers_list.add((Object)CommandReplyEditSpec.fileSpoilers_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
            files.forEach(f -> this.fileSpoilers_list.add((Object)CommandReplyEditSpec.fileSpoilers_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<Optional<AllowedMentions>> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder allowedMentions(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentionsOrNull(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            this.components_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(List<LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            this.components_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<Optional<List<LayoutComponent>>> elements) {
            this.components_list = null;
            this.components_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.components_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.components_explicitNull = true;
                }
            });
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(List<LayoutComponent> elements) {
            this.components_list = new ArrayList<LayoutComponent>(elements);
            this.components_explicitNull = false;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder components(@Nullable Iterable<LayoutComponent> elements) {
            if (elements == null) {
                this.components_list = null;
                this.components_explicitNull = true;
            } else {
                this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.components_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder componentsOrNull(@Nullable Iterable<LayoutComponent> elements) {
            if (elements == null) {
                this.components_list = null;
                this.components_explicitNull = true;
            } else {
                this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.components_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAttachment(Attachment element) {
            this.attachments_getOrCreate().add(element);
            this.attachments_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllAttachments(List<Attachment> elements) {
            this.attachments_getOrCreate().addAll(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder attachments(Possible<Optional<List<Attachment>>> elements) {
            this.attachments_list = null;
            this.attachments_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.attachments_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.attachments_explicitNull = true;
                }
            });
            return this;
        }

        @CanIgnoreReturnValue
        public Builder attachments(List<Attachment> elements) {
            this.attachments_list = new ArrayList<Attachment>(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder attachments(@Nullable Iterable<Attachment> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder attachmentsOrNull(@Nullable Iterable<Attachment> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public CommandReplyEditSpec build() {
            return new CommandReplyEditSpec(this.content_build(), this.embeds_build(), this.files_build(), this.fileSpoilers_build(), this.allowedMentions_build(), this.components_build(), this.attachments_build());
        }

        private Possible<Optional<String>> content_build() {
            return this.content_possible;
        }

        private Possible<Optional<List<EmbedCreateSpec>>> embeds_build() {
            return this.embeds_list == null && !this.embeds_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_list));
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private ImmutableList<MessageCreateFields.File> files_build() {
            return this.files_list.build();
        }

        private ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_build() {
            return this.fileSpoilers_list.build();
        }

        private Possible<Optional<AllowedMentions>> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<Optional<List<LayoutComponent>>> components_build() {
            return this.components_list == null && !this.components_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.components_list));
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }

        private Possible<Optional<List<Attachment>>> attachments_build() {
            return this.attachments_list == null && !this.attachments_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_list));
        }

        private List<Attachment> attachments_getOrCreate() {
            if (this.attachments_list == null) {
                this.attachments_list = new ArrayList<Attachment>();
            }
            return this.attachments_list;
        }
    }
}

