/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public record Invocation(List<String> chain) implements Iterable<String>
{
    public static final Invocation EMPTY = Invocation.of(new String[0]);

    @Pure
    public Invocation(List<String> chain) {
        chain.forEach(c -> Objects.requireNonNull(c, "Invocation chain cannot contain null."));
        this.chain = List.copyOf(chain);
    }

    @Pure
    public Invocation child(String command) {
        List<String> childChain = List.of(Objects.requireNonNull(command, "Command cannot be null."));
        return new Invocation(ListUtils.union(this.chain, childChain));
    }

    @Pure
    public Invocation parent() {
        return new Invocation(this.chain.subList(0, this.chain.size() - 1));
    }

    @Pure
    public static Invocation of(List<String> commands) {
        return new Invocation(commands);
    }

    @Pure
    public static Invocation of(String ... commands) {
        return Invocation.of(Arrays.asList(commands));
    }

    @Override
    public Iterator<String> iterator() {
        return this.chain.iterator();
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.chain.spliterator();
    }

    @SideEffectFree
    public Stream<String> stream() {
        return this.chain.stream();
    }
}

