package dev.sympho.modular_commands.api.command.parameter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Parameter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new Parameter.Builder()}.
 */
@Generated(from = "Parameter", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableParameter<T extends java.lang.@NonNull Object>
    implements Parameter<T> {
  private final java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name;
  private final java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description;
  private final boolean required;
  private final @Nullable T defaultValue;
  private final ArgumentParser<?, T> parser;

  private ImmutableParameter(ImmutableParameter.Builder<T> builder) {
    this.name = builder.name;
    this.description = builder.description;
    this.defaultValue = builder.defaultValue;
    this.parser = builder.parser;
    this.required = builder.requiredIsSet()
        ? builder.required
        : Parameter.super.required();
  }

  private ImmutableParameter(
      java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name,
      java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description,
      boolean required,
      @Nullable T defaultValue,
      ArgumentParser<?, T> parser) {
    this.name = name;
    this.description = description;
    this.required = required;
    this.defaultValue = defaultValue;
    this.parser = parser;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description() {
    return description;
  }

  /**
   * @return The value of the {@code required} attribute
   */
  @Override
  public boolean required() {
    return required;
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @Override
  public @Nullable T defaultValue() {
    return defaultValue;
  }

  /**
   * @return The value of the {@code parser} attribute
   */
  @Override
  public ArgumentParser<?, T> parser() {
    return parser;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withName(java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String value) {
    java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return validate(new ImmutableParameter<>(newValue, this.description, this.required, this.defaultValue, this.parser));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withDescription(java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String value) {
    java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return validate(new ImmutableParameter<>(this.name, newValue, this.required, this.defaultValue, this.parser));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#required() required} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for required
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withRequired(boolean value) {
    if (this.required == value) return this;
    return validate(new ImmutableParameter<>(this.name, this.description, value, this.defaultValue, this.parser));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#defaultValue() defaultValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withDefaultValue(@Nullable T value) {
    if (this.defaultValue == value) return this;
    return validate(new ImmutableParameter<>(this.name, this.description, this.required, value, this.parser));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#parser() parser} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parser
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withParser(ArgumentParser<?, T> value) {
    if (this.parser == value) return this;
    ArgumentParser<?, T> newValue = Objects.requireNonNull(value, "parser");
    return validate(new ImmutableParameter<>(this.name, this.description, this.required, this.defaultValue, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParameter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParameter<?>
        && equalTo(0, (ImmutableParameter<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableParameter<?> another) {
    return name.equals(another.name)
        && description.equals(another.description)
        && required == another.required
        && Objects.equals(defaultValue, another.defaultValue)
        && parser.equals(another.parser);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code required}, {@code defaultValue}, {@code parser}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + Booleans.hashCode(required);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + parser.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Parameter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Parameter")
        .omitNullValues()
        .add("name", name)
        .add("description", description)
        .add("required", required)
        .add("defaultValue", defaultValue)
        .add("parser", parser)
        .toString();
  }

  private static <T extends java.lang.@NonNull Object> ImmutableParameter<T> validate(ImmutableParameter<T> instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Parameter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Parameter instance
   */
  public static <T extends java.lang.@NonNull Object> Parameter<T> copyOf(Parameter<T> instance) {
    if (instance instanceof ImmutableParameter<?>) {
      return (ImmutableParameter<T>) instance;
    }
    return new Parameter.Builder<T>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link Parameter Parameter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Parameter", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<T extends java.lang.@NonNull Object> {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private static final long INIT_BIT_PARSER = 0x4L;
    private static final long OPT_BIT_REQUIRED = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private @Nullable java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name;
    private @Nullable java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description;
    private boolean required;
    private @Nullable T defaultValue;
    private @Nullable ArgumentParser<?, T> parser;

    /**
     * Creates a builder for {@link Parameter Parameter} instances.
     * <pre>
     * new Parameter.Builder&amp;lt;T&amp;gt;()
     *    .name(@org.checkerframework.common.value.qual.MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String) // required {@link Parameter#name() name}
     *    .description(@org.checkerframework.common.value.qual.MatchesRegex("(?Us)^.{1,100}+$") String) // required {@link Parameter#description() description}
     *    .required(boolean) // optional {@link Parameter#required() required}
     *    .defaultValue(T | null) // nullable {@link Parameter#defaultValue() defaultValue}
     *    .parser(dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser&amp;lt;?, T&amp;gt;) // required {@link Parameter#parser() parser}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof Parameter.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new Parameter.Builder<T>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code Parameter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Parameter.Builder<T> from(Parameter<T> instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      description(instance.description());
      required(instance.required());
      @Nullable T defaultValueValue = instance.defaultValue();
      if (defaultValueValue != null) {
        defaultValue(defaultValueValue);
      }
      parser(instance.parser());
      return (Parameter.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link Parameter#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Parameter.Builder<T> name(java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return (Parameter.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link Parameter#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Parameter.Builder<T> description(java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return (Parameter.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link Parameter#required() required} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Parameter#required() required}.</em>
     * @param required The value for required 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Parameter.Builder<T> required(boolean required) {
      this.required = required;
      optBits |= OPT_BIT_REQUIRED;
      return (Parameter.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link Parameter#defaultValue() defaultValue} attribute.
     * @param defaultValue The value for defaultValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Parameter.Builder<T> defaultValue(@Nullable T defaultValue) {
      this.defaultValue = defaultValue;
      return (Parameter.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link Parameter#parser() parser} attribute.
     * @param parser The value for parser 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Parameter.Builder<T> parser(ArgumentParser<?, T> parser) {
      this.parser = Objects.requireNonNull(parser, "parser");
      initBits &= ~INIT_BIT_PARSER;
      return (Parameter.Builder<T>) this;
    }

    /**
     * Builds a new {@link Parameter Parameter}.
     * @return An immutable instance of Parameter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Parameter<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableParameter.validate(new ImmutableParameter<T>(this));
    }

    private boolean requiredIsSet() {
      return (optBits & OPT_BIT_REQUIRED) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_PARSER) != 0) attributes.add("parser");
      return "Cannot build Parameter, some of required attributes are not set " + attributes;
    }
  }
}
