/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse.entity;

import dev.sympho.modular_commands.utils.parse.entity.EntityRef;
import dev.sympho.modular_commands.utils.parse.entity.EntityRefUrlParser;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.channel.Channel;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;
import org.checkerframework.dataflow.qual.Pure;

public class ChannelRefUrlParser<C extends @NonNull Channel>
extends EntityRefUrlParser<EntityRef.ChannelRef<C>> {
    private static final Pattern PATH_PATTERN = Pattern.compile("/channels/\\d++/(\\d++)");
    private final Class<C> type;

    @Pure
    public ChannelRefUrlParser(Class<C> type) {
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public String typeName() {
        return "channel";
    }

    @Override
    protected boolean validPath(String path) {
        return PATH_PATTERN.matcher(path).matches();
    }

    @Override
    protected  @Nullable EntityRef.ChannelRef<C> parsePath(String path) {
        Matcher match = PATH_PATTERN.matcher(path);
        if (!match.matches()) {
            return null;
        }
        String channelString = (String)NullnessUtil.castNonNull((Object)match.group(1));
        Snowflake channelId = Snowflake.of((String)channelString);
        return new EntityRef.ChannelRef<C>(this.type, channelId);
    }
}

