/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.utils.parse.ParseUtils;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import java.util.function.Function;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface RawParser<R>
extends Function<String, Mono<R>> {
    public static final RawParser<String> STRING = Mono::just;
    public static final RawParser<Boolean> BOOLEAN = raw -> switch (raw.toLowerCase()) {
        case "true" -> Mono.just((Object)true);
        case "false" -> Mono.just((Object)false);
        default -> Mono.error((Throwable)new InvalidArgumentException("Not a valid boolean: " + raw));
    };
    public static final RawParser<Long> INTEGER = raw -> {
        try {
            return Mono.just((Object)Long.decode(raw));
        }
        catch (NumberFormatException ex) {
            return Mono.error((Throwable)new InvalidArgumentException("Not a valid integer: " + raw, ex));
        }
    };
    public static final RawParser<Double> FLOAT = raw -> {
        try {
            return Mono.just((Object)Double.parseDouble(raw));
        }
        catch (NumberFormatException ex) {
            return Mono.error((Throwable)new InvalidArgumentException("Not a valid number: " + raw, ex));
        }
    };
    public static final RawParser<Snowflake> SNOWFLAKE = raw -> {
        try {
            return Mono.just((Object)Snowflake.of((String)raw));
        }
        catch (NumberFormatException ex) {
            return Mono.error((Throwable)new InvalidArgumentException("Not a valid snowflake: " + raw, ex));
        }
    };

    private static <R> RawParser<R> from(CommandContext context, ParserFunction<String, R> parser) {
        return raw -> {
            try {
                return parser.parse(context, raw);
            }
            catch (InvalidArgumentException ex) {
                return Mono.error((Throwable)ex);
            }
        };
    }

    @SideEffectFree
    public static RawParser<Message> message(CommandContext context) {
        return RawParser.from(context, ParseUtils.MESSAGE);
    }

    @SideEffectFree
    public static RawParser<User> user(CommandContext context) {
        return RawParser.from(context, ParseUtils.USER);
    }

    @SideEffectFree
    public static RawParser<Role> role(CommandContext context) {
        return RawParser.from(context, ParseUtils.ROLE);
    }

    @SideEffectFree
    public static <C extends Channel> RawParser<C> channel(CommandContext context, Class<C> type) {
        return RawParser.from(context, ParseUtils.channel(type));
    }

    @SideEffectFree
    public static RawParser<Snowflake> messageId(CommandContext context) {
        return RawParser.from(context, ParseUtils.MESSAGE_ID);
    }

    @SideEffectFree
    public static RawParser<Snowflake> userId(CommandContext context) {
        return RawParser.from(context, ParseUtils.USER_ID);
    }

    @SideEffectFree
    public static RawParser<Snowflake> roleId(CommandContext context) {
        return RawParser.from(context, ParseUtils.ROLE_ID);
    }

    @SideEffectFree
    public static RawParser<Snowflake> channelId(CommandContext context) {
        return RawParser.from(context, ParseUtils.CHANNEL_ID);
    }

    @SideEffectFree
    public Mono<R> parse(String var1);

    @Override
    @SideEffectFree
    default public Mono<R> apply(String raw) {
        return this.parse(raw);
    }
}

