/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.Parsers;
import dev.sympho.modular_commands.utils.parse.UrlParser;
import dev.sympho.modular_commands.utils.parse.UrlParserUtils;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public interface FunctorUrlParser<T>
extends UrlParser<T> {
    public static <T> FunctorUrlParser<T> choice(Function<URL, @Nullable FunctorUrlParser<T>> parserMapper) {
        return new Choice<T>(parserMapper);
    }

    public static <T> FunctorUrlParser<T> choice(Collection<? extends FunctorUrlParser<T>> parsers) {
        return FunctorUrlParser.choice(UrlParserUtils.toMapper(parsers));
    }

    @SafeVarargs
    public static <T> FunctorUrlParser<T> choice(FunctorUrlParser<T> ... parsers) {
        return FunctorUrlParser.choice(Arrays.asList(parsers));
    }

    public static <T> FunctorUrlParser<T> choiceHost(Map<String, ? extends FunctorUrlParser<T>> parsers) {
        return FunctorUrlParser.choice(UrlParserUtils.toHostMapper(parsers));
    }

    @SideEffectFree
    public Mono<T> parse(URL var1) throws InvalidArgumentException;

    @Override
    default public Mono<T> parse(CommandContext context, URL url) throws InvalidArgumentException {
        return this.parse(url);
    }

    @Override
    @SideEffectFree
    default public <V> UrlParser<V> then(Parsers.Functor<T, V> after) {
        return new PostParser(this, after);
    }

    public static class Choice<T>
    extends ChoiceBase<T, FunctorUrlParser<T>> {
        public Choice(Function<URL, @Nullable FunctorUrlParser<T>> parserMapper) {
            super(parserMapper);
        }
    }

    public static class PostParser<I, T, P1 extends @NonNull FunctorUrlParser<I>, P2 extends  @NonNull Parsers.Functor<I, T>>
    extends UrlParser.PostParser<I, T, P1, P2>
    implements FunctorUrlParser<T> {
        public PostParser(P1 parser, P2 postParser) {
            super(parser, postParser);
        }

        @Override
        public Mono<T> parse(URL url) throws InvalidArgumentException {
            return ((FunctorUrlParser)this.parser).parse(url).flatMap(((Parsers.Functor)this.postParser)::parse);
        }
    }

    public static abstract class ChoiceBase<T, P extends FunctorUrlParser<T>>
    extends UrlParser.ChoiceBase<T, P>
    implements FunctorUrlParser<T> {
        protected ChoiceBase(Function<URL, @Nullable P> parserMapper) {
            super(parserMapper);
        }

        @Override
        public Mono<T> parse(URL url) throws InvalidArgumentException {
            return ((FunctorUrlParser)this.getParser(url)).parse(url);
        }
    }
}

