/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import dev.sympho.modular_commands.api.command.parameter.Parameter;
import java.util.Objects;
import java.util.regex.Pattern;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ParameterUtils {
    private static final Pattern NAME_PATTERN = Pattern.compile("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(?Us)^.{1,100}+$");

    private ParameterUtils() {
    }

    @SideEffectFree
    public static void validateName(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(name, "Name cannot be null.");
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name.");
        }
        if (!name.equals(name.toLowerCase())) {
            throw new IllegalArgumentException("Name must be all lowercase.");
        }
    }

    @SideEffectFree
    public static void validateDescription(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(description, "Description cannot be null.");
        if (!DESCRIPTION_PATTERN.matcher(description).matches()) {
            throw new IllegalArgumentException("Invalid description.");
        }
    }

    @SideEffectFree
    public static void validate(Parameter<?> parameter) throws IllegalArgumentException, NullPointerException {
        ParameterUtils.validateName(parameter.name());
        ParameterUtils.validateDescription(parameter.description());
        Objects.requireNonNull(parameter.parser(), "Parser cannot be null.");
    }
}

