/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidListException;
import dev.sympho.modular_commands.api.command.parameter.parse.StringParser;
import dev.sympho.modular_commands.utils.StringSplitter;
import dev.sympho.modular_commands.utils.parse.TryParser;
import java.util.List;
import java.util.function.Function;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ListParser<T>
extends StringParser<List<T>> {
    public static final StringSplitter.Async DEFAULT_SPLITTER = new StringSplitter.Shell();

    @SideEffectFree
    default public String preprocess(String arg) {
        return arg.trim();
    }

    @Pure
    default public StringSplitter.Async splitter() {
        return DEFAULT_SPLITTER;
    }

    default public boolean failFast() {
        return true;
    }

    @Pure
    default public @IntRange(from=0L, to=0x7FFFFFFFL) int minItems() {
        return 1;
    }

    @Pure
    default public @IntRange(from=1L, to=0x7FFFFFFFL) int maxItems() {
        return Integer.MAX_VALUE;
    }

    @Override
    default public boolean allowMerge() {
        return true;
    }

    @SideEffectFree
    public Mono<T> parseItem(CommandContext var1, String var2);

    private Flux<T> parseAll(CommandContext context, Flux<String> raws) {
        if (this.failFast()) {
            return raws.concatMap(i -> this.parseItem(context, (String)i));
        }
        TryParser parser = TryParser.of(this::parseItem);
        return raws.concatMap(i -> parser.parse(context, (String)i)).collectList().map(TryParser::split).flatMap(r -> ((List)r.getT2()).isEmpty() ? Mono.just((Object)((List)r.getT1())) : Mono.error((Throwable)new InvalidListException((List)r.getT2()))).flatMapIterable(Function.identity());
    }

    @Override
    default public Mono<List<T>> parseArgument(CommandContext context, String raw) throws InvalidArgumentException {
        String target = this.preprocess(raw);
        if (target.isEmpty()) {
            return Mono.just(List.of());
        }
        return this.splitter().splitAsync(target).index().flatMap(v -> (Long)v.getT1() < (long)this.maxItems() ? Mono.just((Object)((String)v.getT2())) : Mono.error((Throwable)new InvalidArgumentException(String.format("Too many items, must be at most %d", this.maxItems())))).transform(f -> this.parseAll(context, (Flux<String>)f)).collectList().flatMap(args -> args.size() >= this.minItems() ? Mono.just((Object)args) : Mono.error((Throwable)new InvalidArgumentException(String.format("Not enough items, must be at least %d", this.minItems()))));
    }
}

