/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.handler;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.context.InteractionCommandContext;
import dev.sympho.modular_commands.api.command.context.MessageCommandContext;
import dev.sympho.modular_commands.api.command.context.SlashCommandContext;
import dev.sympho.modular_commands.api.command.handler.InteractionHandlers;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.MessageHandlers;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.handler.SlashHandlers;
import dev.sympho.modular_commands.api.command.handler.TextHandlers;
import java.util.Collections;
import java.util.List;
import org.checkerframework.dataflow.qual.Pure;
import reactor.core.publisher.Mono;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Handlers {
    public static final InvocationHandler<CommandContext> CONTINUE = ctx -> Mono.empty();

    @Pure
    public InvocationHandler<?> invocation();

    @Pure
    public List<? extends ResultHandler<?>> result();

    public static MessageHandlers message(InvocationHandler<? super MessageCommandContext> invocation, List<? extends ResultHandler<? super MessageCommandContext>> result) {
        return new MessageHandlers.Impl(invocation, result);
    }

    @SafeVarargs
    public static MessageHandlers message(InvocationHandler<? super MessageCommandContext> invocation, ResultHandler<? super MessageCommandContext> ... result) {
        return Handlers.message(invocation, List.of(result));
    }

    public static MessageHandlers message(InvocationHandler<? super MessageCommandContext> invocation) {
        return Handlers.message(invocation, Collections.emptyList());
    }

    public static SlashHandlers slash(InvocationHandler<? super SlashCommandContext> invocation, List<? extends ResultHandler<? super SlashCommandContext>> result) {
        return new SlashHandlers.Impl(invocation, result);
    }

    @SafeVarargs
    public static SlashHandlers slash(InvocationHandler<? super SlashCommandContext> invocation, ResultHandler<? super SlashCommandContext> ... result) {
        return Handlers.slash(invocation, List.of(result));
    }

    public static SlashHandlers slash(InvocationHandler<? super SlashCommandContext> invocation) {
        return Handlers.slash(invocation, Collections.emptyList());
    }

    public static InteractionHandlers interaction(InvocationHandler<? super InteractionCommandContext> invocation, List<? extends ResultHandler<? super InteractionCommandContext>> result) {
        return new InteractionHandlers.Impl(invocation, result);
    }

    @SafeVarargs
    public static InteractionHandlers interaction(InvocationHandler<? super InteractionCommandContext> invocation, ResultHandler<? super InteractionCommandContext> ... result) {
        return Handlers.interaction(invocation, List.of(result));
    }

    public static InteractionHandlers interaction(InvocationHandler<? super InteractionCommandContext> invocation) {
        return Handlers.interaction(invocation, Collections.emptyList());
    }

    public static TextHandlers text(InvocationHandler<CommandContext> invocation, List<? extends ResultHandler<CommandContext>> result) {
        return new TextHandlers.Impl(invocation, result);
    }

    @SafeVarargs
    public static TextHandlers text(InvocationHandler<CommandContext> invocation, ResultHandler<CommandContext> ... result) {
        return Handlers.text(invocation, List.of(result));
    }

    public static TextHandlers text(InvocationHandler<CommandContext> invocation) {
        return Handlers.text(invocation, Collections.emptyList());
    }
}

