/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.context;

import dev.sympho.modular_commands.api.command.context.GuildOverrideAccessContext;
import dev.sympho.modular_commands.api.command.context.UserOverrideAccessContext;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public interface AccessContext {
    @Pure
    public GatewayDiscordClient getClient();

    @Pure
    public User getUser();

    @SideEffectFree
    default public Mono<Member> getMember() {
        return this.getGuildId() == null ? Mono.empty() : this.getMember(this.getGuildId());
    }

    @SideEffectFree
    default public Mono<Member> getMember(Snowflake guildId) {
        return this.getUser().asMember(Objects.requireNonNull(guildId));
    }

    @SideEffectFree
    public Mono<Guild> getGuild();

    @Pure
    public @Nullable Snowflake getGuildId();

    @Pure
    default public boolean isPrivate() {
        return this.getGuildId() == null;
    }

    @SideEffectFree
    default public AccessContext asGuild(@Nullable Snowflake guild) {
        if (Objects.equals(guild, this.getGuildId())) {
            return this;
        }
        return new GuildOverrideAccessContext(this, guild);
    }

    @SideEffectFree
    default public AccessContext asUser(User user) {
        if (Objects.equals(user.getId(), this.getUser().getId())) {
            return this;
        }
        return new UserOverrideAccessContext<AccessContext>(this, user);
    }

    public static AccessContext of(final Member member) {
        return new AccessContext(){

            @Override
            public GatewayDiscordClient getClient() {
                return member.getClient();
            }

            @Override
            public User getUser() {
                return member;
            }

            @Override
            public Mono<Member> getMember() {
                return Mono.just((Object)member);
            }

            @Override
            public Mono<Guild> getGuild() {
                return member.getGuild();
            }

            @Override
            public @Nullable Snowflake getGuildId() {
                return member.getGuildId();
            }

            @Override
            public boolean isPrivate() {
                return false;
            }
        };
    }

    public static AccessContext of(final User user, final @Nullable Snowflake guild) {
        return new AccessContext(){

            @Override
            public GatewayDiscordClient getClient() {
                return user.getClient();
            }

            @Override
            public User getUser() {
                return user;
            }

            @Override
            public Mono<Guild> getGuild() {
                return guild == null ? Mono.empty() : this.getClient().getGuildById(guild);
            }

            @Override
            public @Nullable Snowflake getGuildId() {
                return guild;
            }
        };
    }
}

