package dev.sympho.modular_commands.api.command.reply;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.*;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Specification for editing a previosly sent command reply.
 * @version 1.0
 * @since 1.0
 */
@Generated(from = "CommandReplyEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"OverloadMethodsDeclarationOrder", "optional.collection", "all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class CommandReplyEditSpec
    implements CommandReplyEditSpecGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final ImmutableList<MessageCreateFields.File> files;
  private final ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final List<Attachment> attachments_value;
  private final boolean attachments_absent;

  private CommandReplyEditSpec(
      Possible<java.util.Optional<String>> content,
      Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds,
      ImmutableList<MessageCreateFields.File> files,
      ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<java.util.Optional<AllowedMentions>> allowedMentions,
      Possible<java.util.Optional<List<LayoutComponent>>> components,
      Possible<java.util.Optional<List<Attachment>>> attachments) {
    Possible<java.util.Optional<String>> content$impl = content;
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = embeds;
    this.files = files;
    this.fileSpoilers = fileSpoilers;
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = components;
    Possible<java.util.Optional<List<Attachment>>> attachments$impl = attachments;
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
    this.attachments_absent = attachments$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CommandReplyEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new java.util.ArrayList<>();
      return "Cannot build CommandReplyEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The new reply message content.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<String>> content() {
    return content_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(content_value));
  }

  /**
   * The new reply embeds.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(embeds_value));
  }

  /**
   * The new attached files.
   * @return The value.
   */
  @Override
  public List<MessageCreateFields.File> files() {
    return files;
  }

  /**
   * The new spoiler-tagged attached files.
   * @return The value.
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    return fileSpoilers;
  }

  /**
   * The new allowed mentions.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<AllowedMentions>> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(allowedMentions_value));
  }

  /**
   * The new message components.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<List<LayoutComponent>>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(components_value));
  }

  /**
   * The new attachments.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<List<Attachment>>> attachments() {
    return attachments_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(attachments_value));
  }

  public CommandReplyEditSpec withContent(Possible<java.util.Optional<String>> value) {
    Possible<java.util.Optional<String>> newValue = java.util.Objects.requireNonNull(value);
    return new CommandReplyEditSpec(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  @Deprecated
  public CommandReplyEditSpec withContent(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditSpec(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  public CommandReplyEditSpec withContentOrNull(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditSpec(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  public CommandReplyEditSpec withEmbeds(Possible<java.util.Optional<List<EmbedCreateSpec>>> possible) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
    return new CommandReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  @Deprecated
  public CommandReplyEditSpec withEmbeds(@Nullable Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  public CommandReplyEditSpec withEmbedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  @SafeVarargs
  public final CommandReplyEditSpec withEmbeds(EmbedCreateSpec... elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new CommandReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  public CommandReplyEditSpec withFiles(MessageCreateFields.File... elements) {
    ImmutableList<MessageCreateFields.File> newValue = with_withFiles(elements);
    if (this.files == newValue) return this;
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  private ImmutableList<MessageCreateFields.File> with_withFiles(MessageCreateFields.File... elements) {
    final ImmutableList.Builder<MessageCreateFields.File> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( files_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplyEditSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    ImmutableList<MessageCreateFields.File> newValue = with_withFiles(elements);
    if (this.files == newValue) return this;
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  private ImmutableList<MessageCreateFields.File> with_withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    final ImmutableList.Builder<MessageCreateFields.File> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( files_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplyEditSpec withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = with_withFileSpoilers(elements);
    if (this.fileSpoilers == newValue) return this;
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    final ImmutableList.Builder<MessageCreateFields.FileSpoiler> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( fileSpoilers_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplyEditSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = with_withFileSpoilers(elements);
    if (this.fileSpoilers == newValue) return this;
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.attachments());
  }

  private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    final ImmutableList.Builder<MessageCreateFields.FileSpoiler> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( fileSpoilers_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplyEditSpec withAllowedMentions(Possible<java.util.Optional<AllowedMentions>> value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = java.util.Objects.requireNonNull(value);
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.attachments());
  }

  @Deprecated
  public CommandReplyEditSpec withAllowedMentions(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.attachments());
  }

  public CommandReplyEditSpec withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.attachments());
  }

  public CommandReplyEditSpec withComponents(Possible<java.util.Optional<List<LayoutComponent>>> possible) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Objects.requireNonNull(possible);
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.attachments());
  }

  @Deprecated
  public CommandReplyEditSpec withComponents(@Nullable Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.attachments());
  }

  public CommandReplyEditSpec withComponentsOrNull(@Nullable Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.attachments());
  }

  @SafeVarargs
  public final CommandReplyEditSpec withComponents(LayoutComponent... elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.attachments());
  }

  public CommandReplyEditSpec withAttachments(Possible<java.util.Optional<List<Attachment>>> possible) {
    Possible<java.util.Optional<List<Attachment>>> newValue = Objects.requireNonNull(possible);
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  @Deprecated
  public CommandReplyEditSpec withAttachments(@Nullable Iterable<Attachment> elements) {
    Possible<java.util.Optional<List<Attachment>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  public CommandReplyEditSpec withAttachmentsOrNull(@Nullable Iterable<Attachment> elements) {
    Possible<java.util.Optional<List<Attachment>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  @SafeVarargs
  public final CommandReplyEditSpec withAttachments(Attachment... elements) {
    Possible<java.util.Optional<List<Attachment>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new CommandReplyEditSpec(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code CommandReplyEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof CommandReplyEditSpec
        && equalTo(0, (CommandReplyEditSpec) another);
  }

  private boolean equalTo(int synthetic, CommandReplyEditSpec another) {
    return this.content().equals(another.content())
        && Objects.equals(embeds_value, another.embeds_value)
        && this.files().equals(another.files())
        && this.fileSpoilers().equals(another.fileSpoilers())
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value)
        && Objects.equals(attachments_value, another.attachments_value);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code components}, {@code attachments}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + (files().hashCode());
    h += (h << 5) + (fileSpoilers().hashCode());
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + (Objects.hashCode(attachments_value));
    return h;
  }

  /**
   * Prints the immutable value {@code CommandReplyEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommandReplyEditSpec")
        .omitNullValues()
        .add("content", content().toString())
        .add("embeds", Objects.toString(embeds_value))
        .add("files", files().toString())
        .add("fileSpoilers", fileSpoilers().toString())
        .add("allowedMentions", allowedMentions().toString())
        .add("components", Objects.toString(components_value))
        .add("attachments", Objects.toString(attachments_value))
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommandReplyEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommandReplyEditSpec instance
   */
  static CommandReplyEditSpec copyOf(CommandReplyEditSpecGenerator instance) {
    if (instance instanceof CommandReplyEditSpec) {
      return (CommandReplyEditSpec) instance;
    }
    return CommandReplyEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  private static ImmutableList<MessageCreateFields.File> files_of(Collection<? extends MessageCreateFields.File> input) {
    final ImmutableList.Builder<MessageCreateFields.File> fs = ImmutableList.builder();
    input.stream().map( f -> files_copy( f ) ).forEach( fs::add );
    return fs.build();
  }

  private static ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_of(Collection<? extends MessageCreateFields.FileSpoiler> input) {
    final ImmutableList.Builder<MessageCreateFields.FileSpoiler> fs = ImmutableList.builder();
    input.stream().map( f -> fileSpoilers_copy( f ) ).forEach( fs::add );
    return fs.build();
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  public boolean isAttachmentsPresent() {
    return !attachments_absent;
  }

  public List<Attachment> attachmentsOrElse(List<Attachment> defaultValue) {
    return !attachments_absent ? attachments_value : defaultValue;
  }

  /**
   * Creates a builder for {@link CommandReplyEditSpec CommandReplyEditSpec}.
   * <pre>
   * CommandReplyEditSpec.builder()
   *    .content(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link CommandReplyEditSpec#content() content}
   *    .embeds(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;List&amp;lt;discord4j.core.spec.EmbedCreateSpec&amp;gt;&amp;gt;&amp;gt;) // {@link CommandReplyEditSpec#embeds() embeds}
   *    .files(List&amp;lt;discord4j.core.spec.MessageCreateFields.File&amp;gt;) // {@link CommandReplyEditSpec#files() files}
   *    .fileSpoilers(List&amp;lt;discord4j.core.spec.MessageCreateFields.FileSpoiler&amp;gt;) // {@link CommandReplyEditSpec#fileSpoilers() fileSpoilers}
   *    .allowedMentions(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.AllowedMentions&amp;gt;&amp;gt;) // {@link CommandReplyEditSpec#allowedMentions() allowedMentions}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;&amp;gt;) // {@link CommandReplyEditSpec#components() components}
   *    .attachments(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;List&amp;lt;discord4j.core.object.entity.Attachment&amp;gt;&amp;gt;&amp;gt;) // {@link CommandReplyEditSpec#attachments() attachments}
   *    .build();
   * </pre>
   * @return A new CommandReplyEditSpec builder
   */
  public static CommandReplyEditSpec.Builder builder() {
    return new CommandReplyEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link CommandReplyEditSpec CommandReplyEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommandReplyEditSpecGenerator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Possible<java.util.Optional<String>> content_possible = Possible.absent();
    private List<EmbedCreateSpec> embeds_list = null;
    private boolean embeds_explicitNull;
    private ImmutableList.Builder<MessageCreateFields.File> files_list = ImmutableList.builder();
    private ImmutableList.Builder<MessageCreateFields.FileSpoiler> fileSpoilers_list = ImmutableList.builder();
    private Possible<java.util.Optional<AllowedMentions>> allowedMentions_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;
    private boolean components_explicitNull;
    private List<Attachment> attachments_list = null;
    private boolean attachments_explicitNull;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommandReplyEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CommandReplyEditSpec instance) {
      return from((CommandReplyEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code CommandReplyEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(CommandReplyEditSpecGenerator instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      content(instance.content());
      embeds(instance.embeds());
      files(instance.files());
      fileSpoilers(instance.fileSpoilers());
      allowedMentions(instance.allowedMentions());
      components(instance.components());
      attachments(instance.attachments());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(Possible<java.util.Optional<String>> value) {
      this.content_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder content(@Nullable String value) {
      this.content_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder contentOrNull(@Nullable String value) {
      this.content_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addEmbed(EmbedCreateSpec element) {
      embeds_getOrCreate().add(element);
      this.embeds_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
      embeds_getOrCreate().addAll(elements);
      this.embeds_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(Possible<java.util.Optional<List<EmbedCreateSpec>>> elements) {
      this.embeds_list = null;
      this.embeds_explicitNull = false;
      elements.toOptional().ifPresent(e -> {
        if (e.isPresent()) {
          embeds_getOrCreate().addAll(e.get());
        } else {
          this.embeds_explicitNull = true;
        }
      });
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(List<EmbedCreateSpec> elements) {
      this.embeds_list = new ArrayList<>(elements);
      this.embeds_explicitNull = false;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder embeds(@Nullable Iterable<EmbedCreateSpec> elements) {
      if (elements == null) {
        this.embeds_list = null;
        this.embeds_explicitNull = true;
      } else {
        this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.embeds_explicitNull = false;
      }
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
      if (elements == null) {
        this.embeds_list = null;
        this.embeds_explicitNull = true;
      } else {
        this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.embeds_explicitNull = false;
      }
      return this;
    }

    @CanIgnoreReturnValue
    public Builder files(Iterable<? extends MessageCreateFields.File> files) {
      this.files_list = ImmutableList.builder();
      files.forEach( f -> files_list.add( files_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addFile(MessageCreateFields.File... files) {
      java.util.Arrays.asList( files ).forEach( f -> files_list.add( files_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllFiles(Iterable<? extends MessageCreateFields.File> files) {
      files.forEach( f -> files_list.add( files_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
      this.fileSpoilers_list = ImmutableList.builder();
      files.forEach( f -> fileSpoilers_list.add( fileSpoilers_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addFileSpoiler(MessageCreateFields.FileSpoiler... files) {
      java.util.Arrays.asList( files ).forEach( f -> fileSpoilers_list.add( fileSpoilers_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
      files.forEach( f -> fileSpoilers_list.add( fileSpoilers_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(Possible<java.util.Optional<AllowedMentions>> value) {
      this.allowedMentions_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder allowedMentions(@Nullable AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentionsOrNull(@Nullable AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      this.components_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      this.components_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<java.util.Optional<List<LayoutComponent>>> elements) {
      this.components_list = null;
      this.components_explicitNull = false;
      elements.toOptional().ifPresent(e -> {
        if (e.isPresent()) {
          components_getOrCreate().addAll(e.get());
        } else {
          this.components_explicitNull = true;
        }
      });
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      this.components_explicitNull = false;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder components(@Nullable Iterable<LayoutComponent> elements) {
      if (elements == null) {
        this.components_list = null;
        this.components_explicitNull = true;
      } else {
        this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.components_explicitNull = false;
      }
      return this;
    }

    @CanIgnoreReturnValue
    public Builder componentsOrNull(@Nullable Iterable<LayoutComponent> elements) {
      if (elements == null) {
        this.components_list = null;
        this.components_explicitNull = true;
      } else {
        this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.components_explicitNull = false;
      }
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAttachment(Attachment element) {
      attachments_getOrCreate().add(element);
      this.attachments_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllAttachments(List<Attachment> elements) {
      attachments_getOrCreate().addAll(elements);
      this.attachments_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder attachments(Possible<java.util.Optional<List<Attachment>>> elements) {
      this.attachments_list = null;
      this.attachments_explicitNull = false;
      elements.toOptional().ifPresent(e -> {
        if (e.isPresent()) {
          attachments_getOrCreate().addAll(e.get());
        } else {
          this.attachments_explicitNull = true;
        }
      });
      return this;
    }

    @CanIgnoreReturnValue
    public Builder attachments(List<Attachment> elements) {
      this.attachments_list = new ArrayList<>(elements);
      this.attachments_explicitNull = false;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder attachments(@Nullable Iterable<Attachment> elements) {
      if (elements == null) {
        this.attachments_list = null;
        this.attachments_explicitNull = true;
      } else {
        this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.attachments_explicitNull = false;
      }
      return this;
    }

    @CanIgnoreReturnValue
    public Builder attachmentsOrNull(@Nullable Iterable<Attachment> elements) {
      if (elements == null) {
        this.attachments_list = null;
        this.attachments_explicitNull = true;
      } else {
        this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.attachments_explicitNull = false;
      }
      return this;
    }

    /**
     * Builds a new {@link CommandReplyEditSpec CommandReplyEditSpec}.
     * @return An immutable instance of CommandReplyEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CommandReplyEditSpec build() {
      return new CommandReplyEditSpec(
          content_build(),
          embeds_build(),
          files_build(),
          fileSpoilers_build(),
          allowedMentions_build(),
          components_build(),
          attachments_build());
    }

    private Possible<java.util.Optional<String>> content_build() {
      return this.content_possible;
    }

    private Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds_build() {
      return this.embeds_list == null && !embeds_explicitNull ? Possible.absent() :
          Possible.of(Optional.ofNullable(this.embeds_list));
    }

    private List<EmbedCreateSpec> embeds_getOrCreate() {
      if (this.embeds_list == null) {
        this.embeds_list = new ArrayList<>();
      }
      return this.embeds_list;
    }

    private ImmutableList<MessageCreateFields.File> files_build() {
      return files_list.build();
    }

    private ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_build() {
      return fileSpoilers_list.build();
    }

    private Possible<java.util.Optional<AllowedMentions>> allowedMentions_build() {
      return this.allowedMentions_possible;
    }

    private Possible<java.util.Optional<List<LayoutComponent>>> components_build() {
      return this.components_list == null && !components_explicitNull ? Possible.absent() :
          Possible.of(Optional.ofNullable(this.components_list));
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }

    private Possible<java.util.Optional<List<Attachment>>> attachments_build() {
      return this.attachments_list == null && !attachments_explicitNull ? Possible.absent() :
          Possible.of(Optional.ofNullable(this.attachments_list));
    }

    private List<Attachment> attachments_getOrCreate() {
      if (this.attachments_list == null) {
        this.attachments_list = new ArrayList<>();
      }
      return this.attachments_list;
    }
  }

  private static MessageCreateFields.File files_copy(MessageCreateFields.File file) {
    return MessageCreateFields.File.of( file.name(), file.inputStream() );
  }

  private static MessageCreateFields.FileSpoiler fileSpoilers_copy(MessageCreateFields.FileSpoiler file) {
    return MessageCreateFields.FileSpoiler.of( file.name(), file.inputStream() );
  }
}
