/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import java.util.List;
import org.checkerframework.common.value.qual.IntRange;

public final class SizeUtils {
    private static final int FACTOR = 1000;
    public static final int KILO = 1000;
    public static final int MEGA = 1000000;
    public static final int GIGA = 1000000000;
    public static final long TERA = 1000000000000L;
    private static final List<Prefix> PREFIXES = List.of(new Prefix("T", 1000000000000L), new Prefix("G", 1000000000L), new Prefix("M", 1000000L), new Prefix("K", 1000L));

    private SizeUtils() {
    }

    public static int kilo(@IntRange(from=0L, to=2147483L) int size) {
        return size * 1000;
    }

    public static long kilo(@IntRange(from=0L, to=9223372036854775L) long size) {
        return size * 1000L;
    }

    public static int mega(@IntRange(from=0L, to=2147L) int size) {
        return size * 1000000;
    }

    public static long mega(@IntRange(from=0L, to=9223372036854L) long size) {
        return size * 1000000L;
    }

    public static int giga(@IntRange(from=0L, to=2L) int size) {
        return size * 1000000000;
    }

    public static long giga(@IntRange(from=0L, to=9223372036L) long size) {
        return size * 1000000000L;
    }

    public static long tera(@IntRange(from=0L, to=0x8CBCCCL) long size) {
        return size * 1000000000000L;
    }

    public static String format(@IntRange(from=0L) long size) {
        return PREFIXES.stream().dropWhile(p -> p.value() > size).findFirst().map(p -> p.format(size)).orElseGet(() -> "%d bytes".formatted(size));
    }

    private record Prefix(String prefix, long value) {
        public String format(@IntRange(from=0L) long size) {
            double s = size;
            double v = s / (double)this.value;
            return "%.2f%sB".formatted(v, this.prefix);
        }
    }
}

