/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import dev.sympho.modular_commands.api.command.reply.CommandReplyEditSpec;
import dev.sympho.modular_commands.api.command.reply.CommandReplySpec;
import dev.sympho.modular_commands.api.command.reply.Reply;
import dev.sympho.modular_commands.api.command.reply.ReplyManager;
import dev.sympho.modular_commands.impl.context.AbstractReplyManager;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.entity.channel.PrivateChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.rest.util.Color;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public class MessageReplyManager
extends AbstractReplyManager {
    private final Message original;
    private final ReplyChain publicChain;
    private final ReplyChain privateChain;

    @SideEffectFree
    public MessageReplyManager(Message original, Mono<MessageChannel> publicChannel, @Nullable Mono<PrivateChannel> privateChannel, boolean defaultPrivate, boolean deferred) {
        super(defaultPrivate, deferred);
        this.original = Objects.requireNonNull(original);
        this.publicChain = new ReplyChain(publicChannel, original.getId());
        this.privateChain = privateChannel == null ? this.publicChain : new ReplyChain(privateChannel, null);
    }

    private String getOriginalUrl() {
        String guild = this.original.getGuildId().map(Snowflake::asString).orElse("@me");
        String channel = this.original.getChannelId().asString();
        String message = this.original.getId().asString();
        return "https://discord.com/channels/%s/%s/%s".formatted(guild, channel, message);
    }

    @Override
    protected Mono<Reply> send(int index, CommandReplySpec spec) {
        ReplyChain channel = spec.privatelyOrElse(this.defaultPrivate) != false ? this.privateChain : this.publicChain;
        return channel.send(index, spec.toMessage());
    }

    @Override
    public ReplyManager longTerm() {
        return this;
    }

    private class ReplyChain {
        private final Mono<? extends MessageChannel> channel;
        private @MonotonicNonNull Snowflake last;

        ReplyChain(@Nullable Mono<? extends MessageChannel> channel, Snowflake last) {
            this.channel = Objects.requireNonNull(channel);
            this.last = last;
        }

        private Mono<Reply> send(int index, MessageCreateSpec spec, MessageChannel channel) {
            Mono prevId;
            if (this.last == null) {
                EmbedCreateSpec reference = EmbedCreateSpec.builder().color(Color.WHITE).addField("command", MessageReplyManager.this.original.getContent(), false).addField("source", MessageReplyManager.this.getOriginalUrl(), false).build();
                prevId = channel.createMessage(new EmbedCreateSpec[]{reference}).map(Message::getId);
            } else {
                prevId = Mono.just((Object)this.last);
            }
            return prevId.map(arg_0 -> ((MessageCreateSpec)spec).withMessageReference(arg_0)).flatMap(arg_0 -> ((MessageChannel)channel).createMessage(arg_0)).map(Message::getId).doOnNext(id -> {
                this.last = id;
            }).map(id -> new MessageReply(index, (Snowflake)id, channel.getId(), channel.getClient()));
        }

        public Mono<Reply> send(int index, MessageCreateSpec spec) {
            return this.channel.flatMap(ch -> this.send(index, spec, (MessageChannel)ch));
        }
    }

    private record MessageReply(int index, Snowflake id, Snowflake channel, GatewayDiscordClient client) implements Reply
    {
        @Override
        public Mono<Message> message() {
            return this.client.getMessageById(this.channel, this.id);
        }

        @Override
        public Mono<Message> edit(CommandReplyEditSpec spec) {
            return this.message().flatMap(m -> m.edit(spec.toMessage()));
        }

        @Override
        public Mono<Void> delete() {
            return this.message().flatMap(Message::delete);
        }
    }
}

