/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.Results;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.execute.InvocationUtils;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.entity.channel.TextChannel;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class InvocationValidator<E extends Event> {
    private final List<Validator<?>> validators = List.of(new NsfwValidator());

    protected abstract User getCaller(E var1);

    protected abstract Mono<MessageChannel> getChannel(E var1);

    protected abstract Mono<Guild> getGuild(E var1);

    public Mono<CommandResult> validateSettings(E event, List<? extends Command<?>> chain) {
        Command<?> command = InvocationUtils.getSettingsSource(chain);
        return Flux.fromIterable(this.validators).flatMap(v -> v.validate(command, event)).next();
    }

    public Mono<CommandResult> validateAccess(AccessValidator validator, List<? extends Command<?>> chain) {
        return Mono.fromSupplier(() -> InvocationUtils.accumulateGroups(chain)).flatMapMany(Flux::fromIterable).flatMap(validator::validate).next();
    }

    private final class NsfwValidator
    extends Validator<MessageChannel> {
        NsfwValidator() {
        }

        @Override
        public boolean active(Command<?> command) {
            return command.nsfw();
        }

        @Override
        public Mono<MessageChannel> getValue(E event) {
            return InvocationValidator.this.getChannel(event);
        }

        @Override
        public @Nullable String validate(User caller, MessageChannel channel) {
            TextChannel ch;
            if (channel instanceof TextChannel && (ch = (TextChannel)channel).isNsfw()) {
                return null;
            }
            return "Command can only be called from a NSFW channel.";
        }
    }

    private abstract class Validator<T> {
        private Validator() {
        }

        protected abstract boolean active(Command<?> var1);

        protected abstract Mono<T> getValue(E var1);

        protected abstract @Nullable String validate(User var1, T var2);

        public Mono<CommandResult> validate(Command<?> command, E event) {
            if (this.active(command)) {
                return this.getValue(event).mapNotNull(v -> this.validate(InvocationValidator.this.getCaller(event), v)).map(Results::failure);
            }
            return Mono.empty();
        }
    }
}

