/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.execute.PrefixProvider;
import discord4j.common.util.Snowflake;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public record GuildPrefix(Map<Snowflake, String> prefixes, String defaultPrefix) implements PrefixProvider
{
    public GuildPrefix(Map<Snowflake, String> prefixes, String defaultPrefix) {
        this.prefixes = new ConcurrentHashMap<Snowflake, String>(prefixes);
        this.defaultPrefix = defaultPrefix;
    }

    public GuildPrefix(String defaultPrefix) {
        this(Collections.emptyMap(), defaultPrefix);
    }

    public void setPrefix(Snowflake guildId, String prefix) {
        this.prefixes.put(guildId, prefix);
    }

    public boolean clearPrefix(Snowflake guildId) {
        return this.prefixes.remove(guildId) != null;
    }

    @Override
    public String getPrefix(@Nullable Snowflake guildId) {
        if (guildId != null) {
            return this.prefixes.getOrDefault(guildId, this.defaultPrefix);
        }
        return this.defaultPrefix;
    }
}

