/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.context;

import dev.sympho.modular_commands.api.command.context.AccessContext;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;
import reactor.core.publisher.Mono;

class GuildOverrideAccessContext
implements AccessContext {
    private final AccessContext base;
    private final @Nullable Snowflake guild;

    GuildOverrideAccessContext(AccessContext base, @Nullable Snowflake guild) {
        this.base = base;
        this.guild = guild;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.base.getClient();
    }

    @Override
    public User getUser() {
        return this.base.getUser();
    }

    @Override
    public Mono<Guild> getGuild() {
        return this.guild == null ? Mono.empty() : this.base.getClient().getGuildById(this.guild).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("Guild %s not found".formatted(NullnessUtil.castNonNull((Object)this.guild)))));
    }

    @Override
    public @Nullable Snowflake getGuildId() {
        return this.guild;
    }

    @Override
    public boolean isPrivate() {
        return this.guild == null;
    }
}

