/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.context;

import dev.sympho.modular_commands.api.command.context.GuildOverrideAccessContext;
import dev.sympho.modular_commands.api.command.context.UserOverrideAccessContext;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public interface AccessContext {
    @Pure
    public GatewayDiscordClient getClient();

    @Pure
    public User getUser();

    @SideEffectFree
    default public Mono<Member> getMember() {
        return this.getGuildId() == null ? Mono.empty() : this.getMember(this.getGuildId());
    }

    @SideEffectFree
    default public Mono<Member> getMember(Snowflake guildId) {
        return this.getUser().asMember(Objects.requireNonNull(guildId));
    }

    @SideEffectFree
    public Mono<Guild> getGuild();

    @Pure
    public @Nullable Snowflake getGuildId();

    @Pure
    default public boolean isPrivate() {
        return this.getGuildId() == null;
    }

    @SideEffectFree
    default public AccessContext asGuild(@Nullable Snowflake guild) {
        if (Objects.equals(guild, this.getGuildId())) {
            return this;
        }
        return new GuildOverrideAccessContext(this, guild);
    }

    @SideEffectFree
    default public AccessContext asUser(User user) {
        if (Objects.equals(user.getId(), this.getUser().getId())) {
            return this;
        }
        return new UserOverrideAccessContext<AccessContext>(this, user);
    }
}

