/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse.entity;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.utils.parse.UrlParser;
import dev.sympho.modular_commands.utils.parse.UrlParserUtils;
import dev.sympho.modular_commands.utils.parse.entity.EntityRef;
import discord4j.core.object.entity.Entity;
import java.net.URL;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public abstract class EntityRefUrlParser<R extends EntityRef<? extends @NonNull Entity>>
implements UrlParser<R> {
    @Pure
    protected abstract boolean validPath(String var1);

    @SideEffectFree
    protected abstract @Nullable R parsePath(String var1);

    @Pure
    protected abstract String typeName();

    @Pure
    private boolean baseValid(URL url) {
        return UrlParserUtils.isHttps(url) && UrlParserUtils.isHost(url, "discord.com");
    }

    @Override
    public boolean supports(URL url) {
        return this.baseValid(url) && this.validPath(url.getPath());
    }

    @SideEffectFree
    public final R parse(URL url) throws InvalidArgumentException {
        if (!this.baseValid(url)) {
            throw new InvalidArgumentException("Not a valid Discord URL: %s".formatted(url));
        }
        R res = this.parsePath(url.getPath());
        if (res == null) {
            throw new InvalidArgumentException("Not a valid %s URL: %s".formatted(this.typeName(), url));
        }
        return res;
    }

    @SideEffectFree
    public final R parse(String raw) throws InvalidArgumentException {
        return this.parse(UrlParser.getUrl(raw));
    }

    @Override
    public final Mono<R> parse(CommandContext context, URL url) throws InvalidArgumentException {
        return Mono.just(this.parse(url));
    }
}

