/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse.entity;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.utils.parse.entity.EntityRef;
import dev.sympho.modular_commands.utils.parse.entity.EntityRefMentionParser;
import dev.sympho.modular_commands.utils.parse.entity.EntityRefUrlParser;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Entity;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public abstract class EntityRefParser<R extends EntityRef<? extends @NonNull Entity>>
implements ParserFunction<String, R> {
    private final @MonotonicNonNull EntityRefUrlParser<R> urlParser;
    private final @MonotonicNonNull EntityRefMentionParser<R> mentionParser;

    @Pure
    protected EntityRefParser(@Nullable EntityRefUrlParser<R> urlParser, @Nullable EntityRefMentionParser<R> mentionParser) {
        this.urlParser = urlParser;
        this.mentionParser = mentionParser;
    }

    @SideEffectFree
    protected abstract R makeRef(CommandContext var1, Snowflake var2);

    @SideEffectFree
    public R parseRef(CommandContext context, String raw) throws InvalidArgumentException {
        Snowflake id;
        R ref;
        if (this.urlParser != null && raw.startsWith("https://")) {
            return this.urlParser.parse(raw);
        }
        if (this.mentionParser != null && (ref = this.mentionParser.parseRef(context, raw)) != null) {
            return ref;
        }
        try {
            id = Snowflake.of((String)raw);
        }
        catch (NumberFormatException ex) {
            throw new InvalidArgumentException("Not a valid ID: " + raw);
        }
        return this.makeRef(context, id);
    }

    @Override
    public Mono<R> parse(CommandContext context, String raw) throws InvalidArgumentException {
        return Mono.just(this.parseRef(context, raw));
    }
}

