/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.utils.parse.UrlParserUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public interface UrlParser<T>
extends ParserFunction<String, T> {
    public static <T> UrlParser<T> choice(Function<URL, @Nullable UrlParser<T>> parserMapper) {
        return new Choice<T>(parserMapper);
    }

    public static <T> UrlParser<T> choice(Collection<? extends UrlParser<T>> parsers) {
        return UrlParser.choice(UrlParserUtils.toMapper(parsers));
    }

    @SafeVarargs
    public static <T> UrlParser<T> choice(UrlParser<T> ... parsers) {
        return UrlParser.choice(Arrays.asList(parsers));
    }

    public static <T> UrlParser<T> choiceHost(Map<String, ? extends UrlParser<T>> parsers) {
        return UrlParser.choice(UrlParserUtils.toHostMapper(parsers));
    }

    @SideEffectFree
    public static URL getUrl(String raw) throws InvalidArgumentException {
        try {
            return new URL(raw);
        }
        catch (MalformedURLException e) {
            throw new InvalidArgumentException("Not a valid URL: " + raw, e);
        }
    }

    @Pure
    public boolean supports(URL var1);

    @Override
    @SideEffectFree
    public Mono<T> parse(CommandContext var1, URL var2) throws InvalidArgumentException;

    @Override
    default public Mono<T> parse(CommandContext context, String raw) throws InvalidArgumentException {
        return this.parse(context, UrlParser.getUrl(raw));
    }

    @SideEffectFree
    default public <V> UrlParser<V> then(ParserFunction<T, V> after) {
        return new PostParser(this, after);
    }

    public static class Choice<T>
    extends ChoiceBase<T, UrlParser<T>> {
        public Choice(Function<URL, @Nullable UrlParser<T>> parserMapper) {
            super(parserMapper);
        }
    }

    public static class PostParser<I, T, P1 extends @NonNull UrlParser<I>, P2 extends @NonNull ParserFunction<I, T>>
    extends ParserFunction.PostParser<String, I, T, P1, P2>
    implements UrlParser<T> {
        public PostParser(P1 parser, P2 postParser) {
            super(parser, postParser);
        }

        @Override
        public boolean supports(URL url) {
            return ((UrlParser)this.parser).supports(url);
        }

        @Override
        public Mono<T> parse(CommandContext context, URL url) throws InvalidArgumentException {
            return ((UrlParser)this.parser).parse(context, url).flatMap(i -> this.postParser.parse(context, i));
        }
    }

    public static abstract class ChoiceBase<T, P extends UrlParser<T>>
    implements UrlParser<T> {
        private final Function<URL, @Nullable P> parserMapper;

        protected ChoiceBase(Function<URL, @Nullable P> parserMapper) {
            this.parserMapper = parserMapper;
        }

        @Override
        public boolean supports(URL url) {
            UrlParser parser = (UrlParser)this.parserMapper.apply(url);
            return parser != null && parser.supports(url);
        }

        @Pure
        protected P getParser(URL url) throws InvalidArgumentException {
            UrlParser parser = (UrlParser)this.parserMapper.apply(url);
            if (parser == null) {
                throw new InvalidArgumentException("Unsupported URL: " + url);
            }
            return (P)parser;
        }

        @Override
        public Mono<T> parse(CommandContext context, URL url) throws InvalidArgumentException {
            return this.getParser(url).parse(context, url);
        }
    }
}

