/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import dev.sympho.modular_commands.api.command.reply.CommandReplySpec;
import dev.sympho.modular_commands.api.command.reply.Reply;
import dev.sympho.modular_commands.api.command.reply.ReplyManager;
import dev.sympho.reactor_utils.concurrent.AsyncLock;
import dev.sympho.reactor_utils.concurrent.ReactiveLock;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Mono;

abstract class AbstractReplyManager
implements ReplyManager {
    protected final List<Reply> replies;
    protected final ReactiveLock sendLock;
    protected final boolean defaultPrivate;
    protected final boolean deferred;

    AbstractReplyManager(boolean defaultPrivate, boolean deferred) {
        this.defaultPrivate = defaultPrivate;
        this.deferred = deferred;
        this.replies = new ArrayList<Reply>();
        this.sendLock = new AsyncLock();
    }

    protected abstract Mono<Reply> send(int var1, CommandReplySpec var2);

    @Override
    public Mono<Reply> add(CommandReplySpec spec) {
        return Mono.fromSupplier(() -> this.deferred && this.replies.isEmpty() ? spec.withPrivately(this.defaultPrivate) : spec).flatMap(s -> this.send(this.replies.size(), (CommandReplySpec)s)).doOnNext(this.replies::add).transform(arg_0 -> ((ReactiveLock)this.sendLock).guard(arg_0));
    }

    @Override
    public Reply get(int index) throws IndexOutOfBoundsException {
        return this.replies.get(index);
    }
}

