/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.result.CommandError;
import dev.sympho.modular_commands.api.command.result.CommandErrorException;
import dev.sympho.modular_commands.api.command.result.CommandFailure;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.CommandSuccess;
import dev.sympho.modular_commands.api.exception.IncompleteHandlingException;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.execute.AccessManager;
import dev.sympho.modular_commands.execute.BaseHandler;
import dev.sympho.modular_commands.execute.InstrumentedContext;
import dev.sympho.modular_commands.execute.InvocationUtils;
import dev.sympho.modular_commands.execute.InvocationValidator;
import dev.sympho.modular_commands.execute.LazyContext;
import dev.sympho.modular_commands.execute.Metrics;
import dev.sympho.modular_commands.utils.SmartIterator;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.collections4.ListUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.observability.micrometer.Micrometer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;
import reactor.util.retry.Retry;

public abstract class PipelineBuilder<E extends Event, CTX extends InstrumentedContext & LazyContext, H extends Handlers, I extends SmartIterator<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineBuilder.class);
    private static final String METRIC_NAME_PIPELINE = Metrics.name("pipeline");
    private static final String METRIC_NAME_EVENT = Metrics.name("event");
    private static final String METRIC_NAME_PARSE = Metrics.name("parse");
    private static final String METRIC_NAME_VALIDATE = Metrics.name("validate");
    private static final String METRIC_NAME_INVOKE = Metrics.name("invoke");
    private static final String METRIC_NAME_HANDLE = Metrics.name("handle");
    private static final String METRIC_NAME_EXECUTE = Metrics.name("execute");
    private static final String METRIC_NAME_RESULT = Metrics.name("result");
    private static final String METRIC_TAG_RESULT = Metrics.name("outcome");
    private static final String METRIC_TAG_HANDLER = Metrics.name("handler");
    private static final int MAX_RETRIES = 100;
    private static final Duration MIN_BACKOFF = Duration.ofSeconds(1L);
    private static final Duration MAX_BACKOFF = Duration.ofHours(1L);
    protected final AccessManager accessManager;
    protected final MeterRegistry meters;
    protected final ObservationRegistry observations;

    protected PipelineBuilder(AccessManager accessManager, MeterRegistry meters, ObservationRegistry observations) {
        this.accessManager = accessManager;
        this.meters = meters;
        this.observations = observations;
    }

    private static String tagResult(CommandResult result) {
        if (result instanceof CommandSuccess) {
            return "success";
        }
        if (result instanceof CommandFailure) {
            return "failure";
        }
        if (result instanceof CommandError) {
            return "error";
        }
        return "unknown";
    }

    private void addTag(String key, String value) {
        Observation observation = this.observations.getCurrentObservation();
        if (observation != null) {
            observation.lowCardinalityKeyValue(key, value);
        }
    }

    private void addTagResult(CommandResult result) {
        this.addTag(METRIC_TAG_RESULT, PipelineBuilder.tagResult(result));
    }

    public Mono<Void> buildPipeline(GatewayDiscordClient client, Registry registry) {
        Flux source = client.on(this.eventType()).filter(this::eventFilter).doOnNext(e -> LOGGER.trace("Received event: {}", e));
        return this.buildPipeline(source, registry).retry();
    }

    @SideEffectFree
    private Mono<Void> buildPipeline(Flux<E> source, Registry registry) {
        return source.flatMap(event -> this.parseEvent(event, registry).switchIfEmpty(Mono.fromRunnable(() -> this.addTag(METRIC_TAG_RESULT, "not_command"))).flatMap(this::executeCommand).contextWrite(Function.identity()).doOnNext(ctx -> {
            InstrumentedContext context = (InstrumentedContext)ctx.getT2();
            CommandResult result = (CommandResult)ctx.getT3();
            if (result instanceof CommandErrorException) {
                CommandErrorException r = (CommandErrorException)result;
                Throwable cause = r.cause();
                LOGGER.error(String.format("Exception while executing command %s", context.getInvocation()), cause);
            } else if (result instanceof CommandError) {
                CommandError r = (CommandError)result;
                LOGGER.error("Error while executing command {}: {}", (Object)context.getInvocation(), (Object)r.message());
            } else {
                LOGGER.debug("Finished command execution {} with result {}", (Object)context.getInvocation(), (Object)result.getClass().getSimpleName());
                LOGGER.trace("{} => {}", (Object)context.getInvocation(), (Object)result);
            }
            this.addTagResult(result);
        }).flatMap(this::handleResult).contextWrite(Function.identity()).doOnError(e -> LOGGER.error("Exception thrown within processing pipeline", e)).contextCapture().checkpoint(METRIC_NAME_EVENT).name(METRIC_NAME_EVENT).transform(this.addTags(event)).tap(Micrometer.observation((ObservationRegistry)this.observations)).onErrorComplete().thenReturn((Object)true)).doOnError(e -> LOGGER.error("Fatal error", e)).checkpoint(METRIC_NAME_PIPELINE).name(METRIC_NAME_PIPELINE).transform(this.tagType()::apply).tap(Micrometer.metrics((MeterRegistry)this.meters)).retryWhen((Retry)Retry.backoff((long)100L, (Duration)MIN_BACKOFF).maxBackoff(MAX_BACKOFF).transientErrors(true)).doOnError(e -> LOGGER.error("Pipeline closed due to too many errors")).then();
    }

    @Pure
    protected abstract Metrics.Tag.Type tagType();

    @SideEffectFree
    protected final <T> Function<Mono<T>, Mono<T>> addTags(E event) {
        return m -> m.transform(this.tagType()::apply);
    }

    @Pure
    protected abstract Class<E> eventType();

    @Pure
    protected abstract Class<H> commandType();

    @Pure
    protected abstract boolean fullMatch();

    @Pure
    protected boolean eventFilter(E event) {
        return true;
    }

    @Pure
    protected abstract InvocationValidator<E> getValidator();

    @SideEffectFree
    protected abstract I parse(E var1);

    @SideEffectFree
    protected abstract CTX makeContext(E var1, Command<? extends H> var2, Invocation var3, I var4);

    @SideEffectFree
    protected abstract Optional<Snowflake> getGuildId(E var1);

    @SideEffectFree
    protected abstract Mono<Guild> getGuild(E var1);

    @SideEffectFree
    protected abstract Snowflake getChannelId(E var1);

    @SideEffectFree
    protected abstract Mono<MessageChannel> getChannel(E var1);

    @SideEffectFree
    protected abstract User getCaller(E var1);

    @SideEffectFree
    protected AccessValidator accessValidator(E event) {
        Mono<Guild> guild = this.getGuild(event);
        Mono<MessageChannel> channel = this.getChannel(event);
        User caller = this.getCaller(event);
        return this.accessManager.validator(guild, channel, caller);
    }

    @Pure
    protected abstract InvocationHandler<? super CTX> getInvocationHandler(H var1);

    @Pure
    protected abstract List<? extends ResultHandler<? super CTX>> getResultHandlers(H var1);

    @Pure
    private boolean checkScope(Tuple4<E, List<Command<? extends H>>, Invocation, I> payload) {
        Event event = (Event)payload.getT1();
        List chain = (List)payload.getT2();
        Object command = InvocationUtils.getInvokedCommand(chain);
        return command.scope() == Command.Scope.GLOBAL || this.getGuildId(event).isPresent();
    }

    @Pure
    private boolean checkCallable(Tuple4<E, List<Command<? extends H>>, Invocation, I> payload) {
        List chain = (List)payload.getT2();
        Object command = InvocationUtils.getInvokedCommand(chain);
        return command.callable();
    }

    @SideEffectFree
    private Mono<Tuple4<E, List<Command<? extends H>>, Invocation, I>> parseEvent(E event, Registry registry) {
        return Mono.just(event).map(e -> Tuples.of((Object)e, this.parse(e))).filter(ctx -> ((SmartIterator)ctx.getT2()).hasNext()).map(ctx -> {
            Event e = (Event)ctx.getT1();
            SmartIterator args = (SmartIterator)ctx.getT2();
            Tuple2<Invocation, List<Command<H>>> parsed = InvocationUtils.parseInvocation(registry, args, this.commandType());
            Invocation invocation = (Invocation)parsed.getT1();
            List chain = (List)parsed.getT2();
            if (this.fullMatch() && args.hasNext()) {
                throw new IllegalStateException("No full match found: " + args.toStream().toList().toString() + " was leftover after " + invocation.toString());
            }
            LOGGER.trace("Matched invocation {}", (Object)invocation);
            return Tuples.of((Object)e, (Object)chain, (Object)invocation, (Object)args);
        }).filter(ctx -> !((List)ctx.getT2()).isEmpty()).filter(this::checkScope).filter(this::checkCallable).contextWrite(Function.identity()).doOnNext(r -> this.addTag(METRIC_TAG_RESULT, "found")).switchIfEmpty(Mono.fromRunnable(() -> this.addTag(METRIC_TAG_RESULT, "not_found"))).checkpoint(METRIC_NAME_PARSE).name(METRIC_NAME_PARSE).transform(this.addTags(event)).tap(Micrometer.observation((ObservationRegistry)this.observations));
    }

    @SideEffectFree
    private Mono<CommandResult> validateCommand(E event, CTX context, List<? extends Command<? extends H>> chain) {
        InvocationValidator<E> validator = this.getValidator();
        AccessValidator access = this.accessValidator(event);
        return validator.validateSettings(event, chain).contextWrite(Function.identity()).doOnNext(r -> this.addTag(METRIC_TAG_RESULT, "invalid")).switchIfEmpty(validator.validateAccess(access, chain)).contextWrite(Function.identity()).doOnNext(r -> this.addTag(METRIC_TAG_RESULT, "no_access")).switchIfEmpty(Mono.fromRunnable(() -> this.addTag(METRIC_TAG_RESULT, "allowed"))).checkpoint(METRIC_NAME_VALIDATE).name(METRIC_NAME_VALIDATE).transform(arg_0 -> context.addTags(arg_0)).tap(Micrometer.observation((ObservationRegistry)this.observations));
    }

    private Mono<CommandResult> invokeCommand(List<? extends @NonNull Command<? extends @NonNull H>> chain, CTX context) {
        Invocation invocation = InvocationUtils.getInvokedCommand(chain).invocation();
        LOGGER.debug("Invoking command {}", (Object)invocation);
        List<Command<H>> commands = InvocationUtils.handlingOrder(chain);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Execution order for {}: {}", (Object)invocation, commands.stream().map(Command::id).toList());
        }
        return Flux.fromIterable(commands).concatMap(c -> this.getInvocationHandler(c.handlers()).handleWrapped(context).contextWrite(Function.identity()).doOnNext(this::addTagResult).switchIfEmpty(Mono.fromRunnable(() -> this.addTag(METRIC_TAG_RESULT, "continue"))).checkpoint(c.id()).name(METRIC_NAME_HANDLE).transform(context::addTags).tag(METRIC_TAG_HANDLER, c.id()).tap(Micrometer.observation((ObservationRegistry)this.observations))).take(1L).switchIfEmpty((Publisher)Mono.error(() -> new IncompleteHandlingException(chain, context.getInvocation()))).single().contextWrite(Function.identity()).doOnNext(this::addTagResult).checkpoint(METRIC_NAME_INVOKE).name(METRIC_NAME_INVOKE).transform(arg_0 -> context.addTags(arg_0)).tap(Micrometer.observation((ObservationRegistry)this.observations));
    }

    private <C extends Command<? extends H>> Mono<Tuple3<C, CTX, CommandResult>> executeCommand(Tuple4<E, List<C>, Invocation, I> payload) {
        Event event = (Event)payload.getT1();
        List chain = (List)payload.getT2();
        Invocation invocation = (Invocation)payload.getT3();
        SmartIterator args = (SmartIterator)payload.getT4();
        Object command = InvocationUtils.getInvokedCommand(chain);
        Object context = this.makeContext((E)event, (Command<? extends H>)command, invocation, (I)args);
        List<String> normalizedInvocation = chain.stream().map(Command::name).toList();
        if (!normalizedInvocation.equals(command.invocation().chain())) {
            throw new IllegalStateException(String.format("Normalized invocation is %s, but command %s has invocation %s", Invocation.of(normalizedInvocation), command.id(), command.invocation()));
        }
        return ((LazyContext)context).initialize(this.observations).contextWrite(Function.identity()).then(Mono.defer(() -> this.validateCommand(event, context, chain))).contextWrite(Function.identity()).switchIfEmpty(Mono.defer(() -> ((LazyContext)((Object)context)).load())).contextWrite(Function.identity()).switchIfEmpty(Mono.defer(() -> this.invokeCommand(chain, context))).contextWrite(Function.identity()).doOnNext(this::addTagResult).map(result -> Tuples.of((Object)command, (Object)context, (Object)result)).checkpoint(METRIC_NAME_EXECUTE).name(METRIC_NAME_EXECUTE).transform(arg_0 -> context.addTags(arg_0)).tap(Micrometer.observation((ObservationRegistry)this.observations));
    }

    private Mono<Void> handleResult(Tuple3<Command<? extends H>, CTX, CommandResult> payload) {
        Command command = (Command)payload.getT1();
        InstrumentedContext context = (InstrumentedContext)payload.getT2();
        CommandResult result = (CommandResult)payload.getT3();
        List handlers = ListUtils.union(this.getResultHandlers(command.handlers()), List.of(BaseHandler.get()));
        return Flux.fromIterable((Iterable)handlers).concatMap(h -> h.handle(context, result)).filter(r -> r).take(1L).count().contextWrite(Function.identity()).filter(c -> c == 0L).doOnNext(c -> LOGGER.warn("Handling of result of command {} not complete", (Object)context.getInvocation())).then().checkpoint(METRIC_NAME_RESULT).name(METRIC_NAME_RESULT).transform(context::addTags).tag(METRIC_TAG_RESULT, PipelineBuilder.tagResult(result)).tap(Micrometer.observation((ObservationRegistry)this.observations));
    }
}

