/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.permission;

import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.api.permission.NamedGroup;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.rest.util.Permission;
import discord4j.rest.util.PermissionSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Groups {
    public static final NamedGroup EVERYONE = Groups.named((guild, channel, user) -> Mono.just((Object)true), "Everyone");
    public static final NamedGroup NOBODY = Groups.named((guild, channel, user) -> Mono.just((Object)false), "Nobody");
    public static final NamedGroup ADMINS = Groups.named(Groups.hasGuildPermissions(PermissionSet.of((Permission[])new Permission[]{Permission.ADMINISTRATOR})), "Administrators");
    public static final NamedGroup SERVER_OWNER = Groups.named((guild, channel, user) -> guild.map(Guild::getOwnerId).map(arg_0 -> ((Snowflake)user.getId()).equals(arg_0)), "Server Owner");
    public static final NamedGroup BOT_OWNER = Groups.named((guild, channel, user) -> user.getClient().getApplicationInfo().map(ApplicationInfo::getOwnerId).map(arg_0 -> ((Snowflake)user.getId()).equals(arg_0)), "Bot Owner");
    public static final NamedGroup BOOSTER = Groups.named((guild, channel, user) -> guild.flatMap(g -> user.asMember(g.getId())).map(PartialMember::getPremiumTime).map(Optional::isPresent).defaultIfEmpty((Object)false), "Boosters");

    private Groups() {
    }

    public static NamedGroup named(Group group, String name) {
        return new Named(group, name);
    }

    public static Group remote(Group group, Mono<Snowflake> guild) {
        return new Remote(group, guild);
    }

    public static NamedGroup remote(NamedGroup group, Mono<Snowflake> guild) {
        return Groups.named(Groups.remote((Group)group, guild), group.name());
    }

    public static Group remote(Group group, Supplier<Snowflake> guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.fromSupplier(guild));
    }

    public static NamedGroup remote(NamedGroup group, Supplier<Snowflake> guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.fromSupplier(guild));
    }

    public static Group remote(Group group, Snowflake guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.just((Object)guild));
    }

    public static NamedGroup remote(NamedGroup group, Snowflake guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.just((Object)guild));
    }

    public static Group any(Flux<Group> groups) {
        return (guild, channel, caller) -> groups.flatMap(g -> g.belongs((Mono<Guild>)guild, (Mono<MessageChannel>)channel, caller)).any(Boolean::booleanValue);
    }

    public static Group any(Stream<Group> groups) {
        return Groups.any((Flux<Group>)Flux.fromStream(groups));
    }

    public static Group any(Iterable<Group> groups) {
        return Groups.any((Flux<Group>)Flux.fromIterable(groups));
    }

    public static Group any(Group ... groups) {
        return Groups.any((Flux<Group>)Flux.fromArray((Object[])groups));
    }

    public static Group all(Flux<Group> groups) {
        return (guild, channel, caller) -> groups.flatMap(g -> g.belongs((Mono<Guild>)guild, (Mono<MessageChannel>)channel, caller)).all(Boolean::booleanValue);
    }

    public static Group all(Stream<Group> groups) {
        return Groups.all((Flux<Group>)Flux.fromStream(groups));
    }

    public static Group all(Iterable<Group> groups) {
        return Groups.all((Flux<Group>)Flux.fromIterable(groups));
    }

    public static Group all(Group ... groups) {
        return Groups.all((Flux<Group>)Flux.fromArray((Object[])groups));
    }

    public static Group isUser(Mono<Snowflake> user) {
        return (guild, channel, caller) -> user.map(arg_0 -> ((Snowflake)caller.getId()).equals(arg_0));
    }

    public static Group isUser(Supplier<Snowflake> user) {
        return Groups.isUser((Mono<Snowflake>)Mono.fromSupplier(user));
    }

    public static Group isUser(Snowflake user) {
        return Groups.isUser((Mono<Snowflake>)Mono.just((Object)user));
    }

    public static Group inWhitelist(Flux<Snowflake> users) {
        return (guild, channel, caller) -> users.any(arg_0 -> ((Snowflake)caller.getId()).equals(arg_0));
    }

    public static Group inWhitelist(Mono<? extends Collection<Snowflake>> users) {
        return (guild, channel, caller) -> users.map(u -> u.contains(caller.getId()));
    }

    public static Group inWhitelist(Supplier<? extends Collection<Snowflake>> users) {
        return Groups.inWhitelist((Mono<? extends Collection<Snowflake>>)Mono.fromSupplier(users));
    }

    public static Group inWhitelist(Collection<Snowflake> users) {
        Set<Snowflake> allowed = Set.copyOf(users);
        return Groups.inWhitelist((Mono<? extends Collection<Snowflake>>)Mono.just(allowed));
    }

    public static Group inWhitelist(Snowflake ... users) {
        return Groups.inWhitelist(Arrays.asList(users));
    }

    public static Group hasRole(Mono<Snowflake> role) {
        return (guild, channel, caller) -> {
            Flux roles = guild.flatMap(g -> g.getMemberById(caller.getId())).flatMapMany(m -> m.getRoles()).map(Role::getId);
            return role.flatMap(r -> roles.any(arg_0 -> ((Snowflake)r).equals(arg_0)));
        };
    }

    public static Group hasRole(Supplier<Snowflake> role) {
        return Groups.hasRole((Mono<Snowflake>)Mono.fromSupplier(role));
    }

    public static Group hasRole(Snowflake role) {
        return Groups.hasRole((Mono<Snowflake>)Mono.just((Object)role));
    }

    public static Group hasRolesAny(Mono<? extends Collection<Snowflake>> roles) {
        return (guild, channel, caller) -> {
            Flux has = guild.flatMap(g -> g.getMemberById(caller.getId())).flatMapMany(m -> m.getRoles()).map(Role::getId);
            return roles.flatMap(r -> has.any(r::contains));
        };
    }

    public static Group hasRolesAny(Flux<Snowflake> roles) {
        Mono allowed = roles.collect(Collectors.toSet());
        return Groups.hasRolesAny((Mono<? extends Collection<Snowflake>>)allowed);
    }

    public static Group hasRolesAny(Supplier<? extends Collection<Snowflake>> roles) {
        return Groups.hasRolesAny((Mono<? extends Collection<Snowflake>>)Mono.fromSupplier(roles));
    }

    public static Group hasRolesAny(Collection<Snowflake> roles) {
        Set<Snowflake> allowed = Set.copyOf(roles);
        return Groups.hasRolesAny((Mono<? extends Collection<Snowflake>>)Mono.just(allowed));
    }

    public static Group hasRolesAny(Snowflake ... roles) {
        return Groups.hasRolesAny(Arrays.asList(roles));
    }

    public static Group hasRolesAll(Flux<Snowflake> roles) {
        return (guild, channel, caller) -> {
            Mono has = guild.flatMap(g -> g.getMemberById(caller.getId())).flatMapMany(m -> m.getRoles()).map(Role::getId).collect(Collectors.toSet());
            return has.flatMap(r -> roles.all(r::contains));
        };
    }

    public static Group hasRolesAll(Mono<? extends Collection<Snowflake>> roles) {
        return (guild, channel, caller) -> {
            Mono has = guild.flatMap(g -> g.getMemberById(caller.getId())).flatMapMany(m -> m.getRoles()).map(Role::getId).collect(Collectors.toSet());
            return Mono.zip((Mono)has, (Mono)roles).map(t -> ((Set)t.getT1()).containsAll((Collection)t.getT2()));
        };
    }

    public static Group hasRolesAll(Supplier<? extends Collection<Snowflake>> roles) {
        return Groups.hasRolesAll((Mono<? extends Collection<Snowflake>>)Mono.fromSupplier(roles));
    }

    public static Group hasRolesAll(Collection<Snowflake> roles) {
        Set<Snowflake> required = Set.copyOf(roles);
        return Groups.hasRolesAll((Mono<? extends Collection<Snowflake>>)Mono.just(required));
    }

    public static Group hasRolesAll(Snowflake ... roles) {
        return Groups.hasRolesAll(Arrays.asList(roles));
    }

    public static Group hasGuildPermissions(Mono<PermissionSet> permissions) {
        return (guild, channel, caller) -> guild.flatMap(g -> g.getMemberById(caller.getId())).flatMap(m -> m.getBasePermissions()).flatMap(p -> permissions.map(arg_0 -> p.containsAll(arg_0))).defaultIfEmpty((Object)true);
    }

    public static Group hasGuildPermissions(Supplier<PermissionSet> permissions) {
        return Groups.hasGuildPermissions((Mono<PermissionSet>)Mono.fromSupplier(permissions));
    }

    public static Group hasGuildPermissions(PermissionSet permissions) {
        return Groups.hasGuildPermissions((Mono<PermissionSet>)Mono.just((Object)permissions));
    }

    public static Group hasChannelPermissions(Mono<PermissionSet> permissions) {
        return (guild, channel, caller) -> channel.filter(GuildChannel.class::isInstance).cast(GuildChannel.class).flatMap(c -> c.getEffectivePermissions(caller.getId())).flatMap(p -> permissions.map(arg_0 -> p.containsAll(arg_0))).defaultIfEmpty((Object)true);
    }

    public static Group hasChannelPermissions(Supplier<PermissionSet> permissions) {
        return Groups.hasChannelPermissions((Mono<PermissionSet>)Mono.fromSupplier(permissions));
    }

    public static Group hasChannelPermissions(PermissionSet permissions) {
        return Groups.hasChannelPermissions((Mono<PermissionSet>)Mono.just((Object)permissions));
    }

    private record Named(Group group, String name) implements NamedGroup
    {
        @Override
        public Mono<Boolean> belongs(Mono<Guild> guild, Mono<MessageChannel> channel, User caller) {
            return this.group.belongs(guild, channel, caller);
        }
    }

    private record Remote(Group group, Mono<Snowflake> remoteGuild) implements Group
    {
        private static Throwable notFound(Snowflake guild) {
            String message = "Guild %s not found".formatted(guild);
            return new IllegalArgumentException(message);
        }

        @Override
        public Mono<Boolean> belongs(Mono<Guild> guild, Mono<MessageChannel> channel, User caller) {
            GatewayDiscordClient client = caller.getClient();
            Mono remote = this.remoteGuild.flatMap(g -> client.getGuildById(g).switchIfEmpty(Mono.error(() -> Remote.notFound(g))));
            return this.group.belongs((Mono<Guild>)remote, channel, caller);
        }
    }
}

