/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import com.google.common.net.MediaType;
import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentDataParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.utils.HttpUtils;
import discord4j.core.object.entity.Attachment;
import java.nio.charset.Charset;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClientResponse;

@FunctionalInterface
public interface TextFileParser<T>
extends AttachmentDataParser<T> {
    @Override
    default public void validate(Attachment attachment) throws InvalidArgumentException {
        if (!attachment.getContentType().map(MediaType::parse).map(t -> t.is(MediaType.ANY_TEXT_TYPE)).orElse(false).booleanValue()) {
            throw new InvalidArgumentException("Attachment must be a text file");
        }
    }

    @Override
    @SideEffectFree
    public Mono<T> parse(CommandContext var1, String var2) throws InvalidArgumentException;

    @Override
    default public Mono<T> parse(CommandContext context, HttpClientResponse response, ByteBufMono body) throws InvalidArgumentException {
        Charset encoding = HttpUtils.getCharset(response, InvalidArgumentException::new);
        return body.asString(encoding).flatMap(c -> this.parse(context, (String)c));
    }
}

