/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentDataParser;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParserStages;
import dev.sympho.modular_commands.api.command.parameter.parse.BooleanParser;
import dev.sympho.modular_commands.api.command.parameter.parse.ChannelArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.ChoicesParser;
import dev.sympho.modular_commands.api.command.parameter.parse.FloatParser;
import dev.sympho.modular_commands.api.command.parameter.parse.IntegerParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ListParser;
import dev.sympho.modular_commands.api.command.parameter.parse.MessageArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.api.command.parameter.parse.RoleArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.SnowflakeParser;
import dev.sympho.modular_commands.api.command.parameter.parse.StringParser;
import dev.sympho.modular_commands.api.command.parameter.parse.TextFileParser;
import dev.sympho.modular_commands.api.command.parameter.parse.UserArgumentParser;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClientResponse;

public final class Parsers {
    private Parsers() {
    }

    @SideEffectFree
    public static <R> Mono<R> raw(CommandContext context, R raw) {
        return Mono.just(raw);
    }

    @SideEffectFree
    private static <P extends Comparable<? super P>> void validateRange(P minimum, P maximum) throws IllegalArgumentException {
        if (minimum.compareTo(maximum) > 0) {
            throw new IllegalArgumentException("Invalid range [%s, %s]".formatted(minimum, maximum));
        }
    }

    @Pure
    public static <R, T> ParserFunction<R, T> functor(Functor<R, T> parser) {
        return Objects.requireNonNull(parser);
    }

    @Pure
    public static <R, T> ParserFunction<R, T> sync(Synchronous<R, T> parser) {
        return Objects.requireNonNull(parser);
    }

    @Pure
    public static <R, T> ParserFunction<R, T> simple(Simple<R, T> parser) {
        return Objects.requireNonNull(parser);
    }

    @SideEffectFree
    public static <R, T> ParserFunction<R, T> nullValue(R value, ParserFunction<R, T> parser) {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(value);
        return (ctx, raw) -> value.equals(raw) ? Mono.empty() : parser.parse(ctx, raw);
    }

    @SideEffectFree
    public static <R> ParserFunction<R, R> nullValue(R value) {
        return Parsers.nullValue(value, Parsers::raw);
    }

    @SideEffectFree
    public static <R, T> ParserFunction<R, T> nullValues(Collection<? extends R> values, ParserFunction<R, T> parser) {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(values);
        return (ctx, raw) -> values.contains(raw) ? Mono.empty() : parser.parse(ctx, raw);
    }

    @SideEffectFree
    public static <R> ParserFunction<R, R> nullValues(Collection<? extends R> values) {
        return Parsers.nullValues(values, Parsers::raw);
    }

    @SideEffectFree
    private static <P, T> ParserFunction<P, T> choiceParser(@MinLen(value=1) List<Map.Entry<ChoicesParser.Choice<P>, T>> choices) throws IllegalArgumentException {
        if (choices.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one choice.");
        }
        Map<Object, Object> mapping = choices.stream().collect(Collectors.toMap(e -> ((ChoicesParser.Choice)e.getKey()).value(), Map.Entry::getValue));
        return Parsers.simple(choice -> NullnessUtil.castNonNull(mapping.get(choice)));
    }

    @SideEffectFree
    private static <P> List<ChoicesParser.Choice<P>> choiceEntries(List<? extends Map.Entry<ChoicesParser.Choice<P>, ?>> choices) {
        return choices.stream().map(Map.Entry::getKey).toList();
    }

    @SideEffectFree
    public static BooleanParser<Boolean> bool() {
        return Parsers.bool(Parsers::raw);
    }

    @SideEffectFree
    public static <T> BooleanParser<T> bool(T trueValue, T falseValue) {
        return Parsers.bool(Parsers.simple(v -> v != false ? trueValue : falseValue));
    }

    @SideEffectFree
    public static <T> BooleanParser<T> bool(ParserFunction<Boolean, T> parser) {
        return new BooleanParserImpl<T>(parser);
    }

    @SideEffectFree
    public static IntegerParser<Long> integer() {
        return Parsers.integer(Parsers::raw);
    }

    @SideEffectFree
    public static <T> IntegerParser<T> integer(ParserFunction<Long, T> parser) {
        return new IntegerParserImpl<T>(null, null, null, parser);
    }

    @SideEffectFree
    public static IntegerParser<Long> integer(@MinLen(value=1) List<ChoicesParser.Choice<Long>> choices) throws IllegalArgumentException {
        return new IntegerParserImpl<Long>(choices, null, null, Parsers::raw);
    }

    @SideEffectFree
    @SafeVarargs
    public static IntegerParser<Long> integer(ChoicesParser.Choice<Long> ... choices) throws IllegalArgumentException {
        return Parsers.integer(Arrays.asList(choices));
    }

    @SideEffectFree
    public static <T> IntegerParser<T> choiceInteger(@MinLen(value=1) List<Map.Entry<ChoicesParser.Choice<Long>, T>> choices) throws IllegalArgumentException {
        return new IntegerParserImpl<T>(Parsers.choiceEntries(choices), null, null, Parsers.choiceParser(choices));
    }

    @SideEffectFree
    @SafeVarargs
    public static <T> IntegerParser<T> choiceInteger(Map.Entry<ChoicesParser.Choice<Long>, T> ... choices) throws IllegalArgumentException {
        return Parsers.choiceInteger(Arrays.asList(choices));
    }

    @SideEffectFree
    public static IntegerParser<Long> integerAbove(long minimum) {
        return Parsers.integerAbove(minimum, Parsers::raw);
    }

    @SideEffectFree
    public static <T> IntegerParser<T> integerAbove(long minimum, ParserFunction<Long, T> parser) {
        return new IntegerParserImpl<T>(null, minimum, null, parser);
    }

    @SideEffectFree
    public static IntegerParser<Long> integerBelow(long maximum) {
        return Parsers.integerBelow(maximum, Parsers::raw);
    }

    @SideEffectFree
    public static <T> IntegerParser<T> integerBelow(long maximum, ParserFunction<Long, T> parser) {
        return new IntegerParserImpl<T>(null, null, maximum, parser);
    }

    @SideEffectFree
    public static IntegerParser<Long> integerBetween(long minimum, long maximum) {
        return Parsers.integerBetween(minimum, maximum, Parsers::raw);
    }

    @SideEffectFree
    public static <T> IntegerParser<T> integerBetween(long minimum, long maximum, ParserFunction<Long, T> parser) {
        Parsers.validateRange(minimum, maximum);
        return new IntegerParserImpl<T>(null, minimum, maximum, parser);
    }

    @SideEffectFree
    public static FloatParser<Double> number() {
        return Parsers.number(Parsers::raw);
    }

    @SideEffectFree
    public static <T> FloatParser<T> number(ParserFunction<Double, T> parser) {
        return new FloatParserImpl<T>(null, null, null, parser);
    }

    @SideEffectFree
    public static FloatParser<Double> number(@MinLen(value=1) List<ChoicesParser.Choice<Double>> choices) throws IllegalArgumentException {
        return new FloatParserImpl<Double>(choices, null, null, Parsers::raw);
    }

    @SideEffectFree
    @SafeVarargs
    public static FloatParser<Double> number(ChoicesParser.Choice<Double> ... choices) throws IllegalArgumentException {
        return Parsers.number(Arrays.asList(choices));
    }

    @SideEffectFree
    public static <T> FloatParser<T> numberChoice(@MinLen(value=1) List<Map.Entry<ChoicesParser.Choice<Double>, T>> choices) throws IllegalArgumentException {
        return new FloatParserImpl<T>(Parsers.choiceEntries(choices), null, null, Parsers.choiceParser(choices));
    }

    @SideEffectFree
    @SafeVarargs
    public static <T> FloatParser<T> numberChoice(Map.Entry<ChoicesParser.Choice<Double>, T> ... choices) throws IllegalArgumentException {
        return Parsers.numberChoice(Arrays.asList(choices));
    }

    @SideEffectFree
    public static FloatParser<Double> numberAbove(double minimum) {
        return Parsers.numberAbove(minimum, Parsers::raw);
    }

    @SideEffectFree
    public static <T> FloatParser<T> numberAbove(double minimum, ParserFunction<Double, T> parser) {
        return new FloatParserImpl<T>(null, minimum, null, parser);
    }

    @SideEffectFree
    public static FloatParser<Double> numberBelow(double maximum) {
        return Parsers.numberBelow(maximum, Parsers::raw);
    }

    @SideEffectFree
    public static <T> FloatParser<T> numberBelow(double maximum, ParserFunction<Double, T> parser) {
        return new FloatParserImpl<T>(null, null, maximum, parser);
    }

    @SideEffectFree
    public static FloatParser<Double> numberBetween(double minimum, double maximum) {
        return Parsers.numberBetween(minimum, maximum, Parsers::raw);
    }

    @SideEffectFree
    public static <T> FloatParser<T> numberBetween(double minimum, double maximum, ParserFunction<Double, T> parser) {
        Parsers.validateRange(minimum, maximum);
        return new FloatParserImpl<T>(null, minimum, maximum, parser);
    }

    @SideEffectFree
    public static StringParser<String> string() {
        return Parsers.string(Parsers::raw);
    }

    @SideEffectFree
    public static StringParser<String> string(@Nullable @IntRange(from=0L, to=6000L) Integer minLength, @Nullable @IntRange(from=1L, to=6000L) Integer maxLength) {
        return Parsers.string(Parsers::raw, minLength, maxLength);
    }

    @SideEffectFree
    public static <T> StringParser<T> string(ParserFunction<String, T> parser) {
        return Parsers.string(parser, null, null);
    }

    @SideEffectFree
    public static <T> StringParser<T> string(ParserFunction<String, T> parser, @Nullable @IntRange(from=0L, to=6000L) Integer minLength, @Nullable @IntRange(from=1L, to=6000L) Integer maxLength) {
        return new StringParserImpl<T>(null, parser, minLength, maxLength, false);
    }

    @SideEffectFree
    public static StringParser<String> string(@MinLen(value=1) List<ChoicesParser.Choice<String>> choices) throws IllegalArgumentException {
        return new StringParserImpl<String>(choices, Parsers::raw, null, null, false);
    }

    @SideEffectFree
    @SafeVarargs
    public static StringParser<String> string(ChoicesParser.Choice<String> ... choices) throws IllegalArgumentException {
        return Parsers.string(Arrays.asList(choices));
    }

    @SideEffectFree
    public static <T> StringParser<T> stringChoice(@MinLen(value=1) List<Map.Entry<ChoicesParser.Choice<String>, T>> choices) throws IllegalArgumentException {
        return new StringParserImpl<T>(Parsers.choiceEntries(choices), Parsers.choiceParser(choices), null, null, false);
    }

    @SideEffectFree
    @SafeVarargs
    public static <T> StringParser<T> stringChoice(Map.Entry<ChoicesParser.Choice<String>, T> ... choices) throws IllegalArgumentException {
        return Parsers.stringChoice(Arrays.asList(choices));
    }

    public static <E extends Enum<E>> StringParser<E> enums(Class<E> enumClass) throws IllegalArgumentException {
        Enum[] values = (Enum[])NullnessUtil.castNonNull((Object)((Enum[])enumClass.getEnumConstants()));
        if (values.length > 25) {
            throw new IllegalArgumentException("Enum type has too many values");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException("Enum type has no values");
        }
        @MinLen(value=1) List<Map.Entry<ChoicesParser.Choice<String>, T>> choices = Arrays.stream(values).map(s -> Map.entry(ChoicesParser.Choice.of(s.toString(), s.name().toLowerCase()), s)).toList();
        return Parsers.stringChoice(choices);
    }

    @SideEffectFree
    public static StringParser<String> text() {
        return Parsers.text(Parsers::raw);
    }

    @SideEffectFree
    public static StringParser<String> text(@Nullable @IntRange(from=0L, to=6000L) Integer minLength, @Nullable @IntRange(from=1L, to=6000L) Integer maxLength) {
        return Parsers.text(Parsers::raw, minLength, maxLength);
    }

    @SideEffectFree
    public static <T> StringParser<T> text(ParserFunction<String, T> parser) {
        return Parsers.text(parser, null, null);
    }

    @SideEffectFree
    public static <T> StringParser<T> text(ParserFunction<String, T> parser, @Nullable @IntRange(from=0L, to=6000L) Integer minLength, @Nullable @IntRange(from=1L, to=6000L) Integer maxLength) {
        return new StringParserImpl<T>(null, parser, minLength, maxLength, true);
    }

    @SideEffectFree
    public static AttachmentParser<Attachment> attachment() {
        return Parsers.attachment(Parsers::raw);
    }

    @SideEffectFree
    public static <T> AttachmentParser<T> attachment(ParserFunction<Attachment, T> parser) {
        return new AttachmentParserImpl<T>(parser);
    }

    @SideEffectFree
    public static <T> AttachmentDataParser<T> attachment(AttachmentParserStages.Validator validator, @IntRange(from=0L) int maxSize, AttachmentParserStages.Parser<T> parser) throws IllegalArgumentException {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Max size must be non-negative");
        }
        return new AttachmentDataParserImpl<T>(Objects.requireNonNull(validator), maxSize, Objects.requireNonNull(parser));
    }

    @SideEffectFree
    public static <T> AttachmentDataParser<T> attachment(@IntRange(from=0L) int maxSize, AttachmentParserStages.Parser<T> parser) {
        return Parsers.attachment(attachment -> {}, maxSize, parser);
    }

    @SideEffectFree
    public static <T> AttachmentDataParser<T> attachment(AttachmentParserStages.Parser<T> parser) {
        return Parsers.attachment(Integer.MAX_VALUE, parser);
    }

    @SideEffectFree
    public static <T> TextFileParser<T> textFile(@IntRange(from=0L) int maxSize, ParserFunction<String, T> parser) {
        return new TextFileParserImpl<T>(maxSize, parser);
    }

    @SideEffectFree
    public static <T> TextFileParser<T> textFile(ParserFunction<String, T> parser) {
        return Parsers.textFile(Integer.MAX_VALUE, parser);
    }

    @SideEffectFree
    public static TextFileParser<String> textFile(@IntRange(from=0L) int maxSize) {
        return Parsers.textFile(maxSize, Parsers::raw);
    }

    @SideEffectFree
    public static TextFileParser<String> textFile() {
        return Parsers.textFile(Integer.MAX_VALUE);
    }

    @SideEffectFree
    public static <T> SnowflakeParser<T> snowflake(ParserFunction<Snowflake, T> parser) {
        return new SnowflakeParserImpl<T>(SnowflakeParser.Type.ANY, parser);
    }

    @SideEffectFree
    public static SnowflakeParser<Snowflake> snowflake() {
        return Parsers.snowflake(Parsers::raw);
    }

    @SideEffectFree
    public static <T> SnowflakeParser<T> userId(ParserFunction<Snowflake, T> parser) {
        return new SnowflakeParserImpl<T>(SnowflakeParser.Type.USER, parser);
    }

    @SideEffectFree
    public static SnowflakeParser<Snowflake> userId() {
        return Parsers.userId(Parsers::raw);
    }

    @SideEffectFree
    public static <T> SnowflakeParser<T> roleId(ParserFunction<Snowflake, T> parser) {
        return new SnowflakeParserImpl<T>(SnowflakeParser.Type.ROLE, parser);
    }

    @SideEffectFree
    public static SnowflakeParser<Snowflake> roleId() {
        return Parsers.roleId(Parsers::raw);
    }

    @SideEffectFree
    public static <T> SnowflakeParser<T> channelId(ParserFunction<Snowflake, T> parser) {
        return new SnowflakeParserImpl<T>(SnowflakeParser.Type.CHANNEL, parser);
    }

    @SideEffectFree
    public static SnowflakeParser<Snowflake> channelId() {
        return Parsers.channelId(Parsers::raw);
    }

    @SideEffectFree
    public static UserArgumentParser<User> user() {
        return Parsers.user(Parsers::raw);
    }

    @SideEffectFree
    public static <T> UserArgumentParser<T> user(ParserFunction<User, T> parser) {
        return parser::parse;
    }

    @SideEffectFree
    public static RoleArgumentParser<Role> role() {
        return Parsers.role(Parsers::raw);
    }

    @SideEffectFree
    public static <T> RoleArgumentParser<T> role(ParserFunction<Role, T> parser) {
        return parser::parse;
    }

    @SideEffectFree
    public static MessageArgumentParser<Message> message() {
        return Parsers.message(Parsers::raw);
    }

    @SideEffectFree
    public static <T> MessageArgumentParser<T> message(ParserFunction<Message, T> parser) {
        return parser::parse;
    }

    @SideEffectFree
    public static <C extends Channel> ChannelArgumentParser<C, C> channel(Class<C> type) {
        return Parsers.channel(type, Parsers::raw);
    }

    @SideEffectFree
    public static <C extends Channel, T> ChannelArgumentParser<C, T> channel(Class<C> type, ParserFunction<C, T> parser) {
        return new ChannelParserImpl<C, T>(type, parser);
    }

    @SideEffectFree
    public static ListParser<String> list() {
        return Parsers.list(Parsers::raw);
    }

    @SideEffectFree
    public static ListParser<String> list(@IntRange(from=0L, to=0x7FFFFFFFL) int minItems, @IntRange(from=1L, to=0x7FFFFFFFL) int maxItems) {
        return Parsers.list(Parsers::raw, minItems, maxItems);
    }

    @SideEffectFree
    public static <T> ListParser<T> list(ParserFunction<String, T> parser) {
        return Parsers.list(parser, 1, Integer.MAX_VALUE);
    }

    @SideEffectFree
    public static <T> ListParser<T> list(ParserFunction<String, T> parser, @IntRange(from=0L, to=0x7FFFFFFFL) int minItems, @IntRange(from=1L, to=0x7FFFFFFFL) int maxItems) {
        return new ListParserImpl<T>(parser, minItems, maxItems);
    }

    @FunctionalInterface
    public static interface Simple<R, T>
    extends ParserFunction<R, T> {
        @SideEffectFree
        public T parseNow(R var1) throws InvalidArgumentException;

        @Override
        default public Mono<T> parse(CommandContext context, R raw) throws InvalidArgumentException {
            return Mono.just(this.parseNow(raw));
        }
    }

    private record BooleanParserImpl<T>(ParserFunction<Boolean, T> parser) implements BooleanParser<T>
    {
        @Override
        public Mono<T> parseArgument(CommandContext context, Boolean raw) {
            return this.parser.parse(context, raw);
        }
    }

    private static final class IntegerParserImpl<T>
    extends Record
    implements IntegerParser<T> {
        private final @Nullable List<ChoicesParser.Choice<Long>> choices;
        private final @Nullable Long minimum;
        private final @Nullable Long maximum;
        private final ParserFunction<Long, T> parser;

        private IntegerParserImpl(@Nullable List<ChoicesParser.Choice<Long>> choices, @Nullable Long minimum, @Nullable Long maximum, ParserFunction<Long, T> parser) {
            this.choices = choices;
            this.minimum = minimum;
            this.maximum = maximum;
            this.parser = parser;
        }

        @Override
        public Mono<T> parseArgument(CommandContext context, Long raw) throws InvalidArgumentException {
            return this.parser.parse(context, raw);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerParserImpl.class, "choices;minimum;maximum;parser", "choices", "minimum", "maximum", "parser"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerParserImpl.class, "choices;minimum;maximum;parser", "choices", "minimum", "maximum", "parser"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerParserImpl.class, "choices;minimum;maximum;parser", "choices", "minimum", "maximum", "parser"}, this, o);
        }

        @Override
        public @Nullable List<ChoicesParser.Choice<Long>> choices() {
            return this.choices;
        }

        @Override
        public @Nullable Long minimum() {
            return this.minimum;
        }

        @Override
        public @Nullable Long maximum() {
            return this.maximum;
        }

        public ParserFunction<Long, T> parser() {
            return this.parser;
        }
    }

    private static final class FloatParserImpl<T>
    extends Record
    implements FloatParser<T> {
        private final @Nullable List<ChoicesParser.Choice<Double>> choices;
        private final @Nullable Double minimum;
        private final @Nullable Double maximum;
        private final ParserFunction<Double, T> parser;

        private FloatParserImpl(@Nullable List<ChoicesParser.Choice<Double>> choices, @Nullable Double minimum, @Nullable Double maximum, ParserFunction<Double, T> parser) {
            this.choices = choices;
            this.minimum = minimum;
            this.maximum = maximum;
            this.parser = parser;
        }

        @Override
        public Mono<T> parseArgument(CommandContext context, Double raw) throws InvalidArgumentException {
            return this.parser.parse(context, raw);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatParserImpl.class, "choices;minimum;maximum;parser", "choices", "minimum", "maximum", "parser"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatParserImpl.class, "choices;minimum;maximum;parser", "choices", "minimum", "maximum", "parser"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatParserImpl.class, "choices;minimum;maximum;parser", "choices", "minimum", "maximum", "parser"}, this, o);
        }

        @Override
        public @Nullable List<ChoicesParser.Choice<Double>> choices() {
            return this.choices;
        }

        @Override
        public @Nullable Double minimum() {
            return this.minimum;
        }

        @Override
        public @Nullable Double maximum() {
            return this.maximum;
        }

        public ParserFunction<Double, T> parser() {
            return this.parser;
        }
    }

    private record StringParserImpl<T>(@Nullable List<ChoicesParser.Choice<String>> choices, ParserFunction<String, T> parser, @IntRange(from=0L, to=6000L) @Nullable Integer minLength, @IntRange(from=1L, to=6000L) @Nullable Integer maxLength, boolean allowMerge) implements StringParser<T>
    {
        @Override
        public Mono<T> parseArgument(CommandContext context, String raw) throws InvalidArgumentException {
            return this.parser.parse(context, raw);
        }
    }

    private record AttachmentParserImpl<T>(ParserFunction<Attachment, T> parser) implements AttachmentParser<T>
    {
        @Override
        public Mono<T> parseArgument(CommandContext context, Attachment raw) throws InvalidArgumentException {
            return this.parser.parse(context, raw);
        }
    }

    private record AttachmentDataParserImpl<T>(AttachmentParserStages.Validator validator, @IntRange(from=0L) int maxSize, AttachmentParserStages.Parser<T> parser) implements AttachmentDataParser<T>
    {
        @Override
        public void validate(Attachment attachment) throws InvalidArgumentException {
            this.validator.validate(attachment);
        }

        @Override
        public Mono<T> parse(CommandContext context, HttpClientResponse response, ByteBufMono body) throws InvalidArgumentException {
            return this.parser.parse(context, response, body);
        }
    }

    private record TextFileParserImpl<T>(@IntRange(from=0L) int maxSize, ParserFunction<String, T> parser) implements TextFileParser<T>
    {
        @Override
        public Mono<T> parse(CommandContext context, String content) throws InvalidArgumentException {
            return this.parser.parse(context, content);
        }
    }

    private record SnowflakeParserImpl<T>(SnowflakeParser.Type type, ParserFunction<Snowflake, T> parser) implements SnowflakeParser<T>
    {
        @Override
        public Mono<T> parseArgument(CommandContext context, Snowflake raw) throws InvalidArgumentException {
            return this.parser.parse(context, raw);
        }
    }

    private record ChannelParserImpl<C extends Channel, T>(Class<C> type, ParserFunction<C, T> parser) implements ChannelArgumentParser<C, T>
    {
        @Override
        public Mono<T> parseArgument(CommandContext context, C raw) throws InvalidArgumentException {
            return this.parser.parse(context, raw);
        }
    }

    private record ListParserImpl<T>(ParserFunction<String, T> parser, @IntRange(from=0L, to=0x7FFFFFFFL) int minItems, @IntRange(from=1L, to=0x7FFFFFFFL) int maxItems) implements ListParser<T>
    {
        @Override
        public Mono<T> parseItem(CommandContext context, String raw) {
            return this.parser.parse(context, raw);
        }
    }

    @FunctionalInterface
    public static interface Synchronous<R, T>
    extends ParserFunction<R, T> {
        @SideEffectFree
        public T parseNow(CommandContext var1, R var2) throws InvalidArgumentException;

        @Override
        default public Mono<T> parse(CommandContext context, R raw) throws InvalidArgumentException {
            return Mono.just(this.parseNow(context, raw));
        }
    }

    @FunctionalInterface
    public static interface Functor<R, T>
    extends ParserFunction<R, T> {
        @SideEffectFree
        public Mono<T> parse(R var1) throws InvalidArgumentException;

        @Override
        default public Mono<T> parse(CommandContext context, R raw) throws InvalidArgumentException {
            return this.parse(raw);
        }
    }
}

