/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter;

import dev.sympho.modular_commands.api.command.parameter.ImmutableParameter;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import dev.sympho.modular_commands.utils.ParameterUtils;
import javax.annotation.Nullable;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE, overshadowImplementation=true)
public interface Parameter<T> {
    public static final @Regex String NAME_REGEX = "(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$";
    public static final @Regex String DESCRIPTION_REGEX = "(?Us)^.{1,100}+$";

    @Pure
    public @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name();

    @Pure
    public @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description();

    @Pure
    @Value.Default
    default public boolean required() {
        return false;
    }

    @Pure
    @Nullable
    public T defaultValue();

    @Pure
    public ArgumentParser<?, T> parser();

    @Pure
    @Value.Check
    default public void validate() throws IllegalArgumentException, NullPointerException {
        ParameterUtils.validate(this);
    }

    @SideEffectFree
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @SideEffectFree
    public static <T> Builder<T> builder(Parameter<T> base) {
        return new Builder<T>().from(base);
    }

    public static class Builder<T>
    extends ImmutableParameter.Builder<T> {
    }
}

