/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.parameter.parse.ListParser;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.api.command.parameter.parse.Parsers;
import dev.sympho.modular_commands.api.command.parameter.parse.StringParser;
import dev.sympho.modular_commands.utils.parse.ChannelParser;
import dev.sympho.modular_commands.utils.parse.MessageParser;
import dev.sympho.modular_commands.utils.parse.RawParser;
import dev.sympho.modular_commands.utils.parse.RoleParser;
import dev.sympho.modular_commands.utils.parse.StringAdapter;
import dev.sympho.modular_commands.utils.parse.UserParser;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ParseUtils {
    public static final ParserFunction<String, Boolean> BOOLEAN = Parsers.functor(RawParser.BOOLEAN::parse);
    public static final ParserFunction<String, Long> INTEGER = Parsers.functor(RawParser.INTEGER::parse);
    public static final ParserFunction<String, Double> FLOAT = Parsers.functor(RawParser.FLOAT::parse);
    public static final ParserFunction<String, Snowflake> SNOWFLAKE = Parsers.functor(RawParser.SNOWFLAKE::parse);
    public static final MessageParser MESSAGE = new MessageParser();
    public static final UserParser USER = new UserParser();
    public static final RoleParser ROLE = new RoleParser();

    private ParseUtils() {
    }

    @SideEffectFree
    public static <C extends Channel> ChannelParser<C> channel(Class<C> type) {
        return new ChannelParser<C>(type);
    }

    @SideEffectFree
    public static <T> ParserFunction<String, T> adaptInteger(ParserFunction<Long, T> parser) {
        return new StringAdapter<Long, T>(INTEGER, parser);
    }

    @SideEffectFree
    public static <T> ParserFunction<String, T> adaptFloat(ParserFunction<Double, T> parser) {
        return new StringAdapter<Double, T>(FLOAT, parser);
    }

    @SideEffectFree
    public static <T> ParserFunction<String, T> adaptSnowflake(ParserFunction<Snowflake, T> parser) {
        return new StringAdapter<Snowflake, T>(SNOWFLAKE, parser);
    }

    @SideEffectFree
    public static <T> ParserFunction<String, T> adaptMessage(ParserFunction<Message, T> parser) {
        return new StringAdapter<Message, T>(MESSAGE, parser);
    }

    @SideEffectFree
    public static <T> ParserFunction<String, T> adaptUser(ParserFunction<User, T> parser) {
        return new StringAdapter<User, T>(USER, parser);
    }

    @SideEffectFree
    public static <T> ParserFunction<String, T> adaptRole(ParserFunction<Role, T> parser) {
        return new StringAdapter<Role, T>(ROLE, parser);
    }

    @SideEffectFree
    public static <C extends Channel, T> ParserFunction<String, T> adaptChannel(ParserFunction<C, T> parser, Class<C> type) {
        return new StringAdapter<C, T>(ParseUtils.channel(type), parser);
    }

    @SideEffectFree
    public static <T> StringParser<Flux<T>> flux(ParserFunction<String, Mono<T>> parser) {
        ListParser p = Parsers.list(parser);
        return (ctx, raw) -> p.parse(ctx, raw).map(Flux::concat);
    }

    @SideEffectFree
    public static ListParser<Long> integers() {
        return Parsers.list(INTEGER);
    }

    @SideEffectFree
    public static ListParser<Double> floats() {
        return Parsers.list(FLOAT);
    }

    @SideEffectFree
    public static ListParser<Snowflake> snowflakes() {
        return Parsers.list(SNOWFLAKE);
    }

    @SideEffectFree
    public static ListParser<Message> messages() {
        return Parsers.list(MESSAGE);
    }

    @SideEffectFree
    public static ListParser<User> users() {
        return Parsers.list(USER);
    }

    @SideEffectFree
    public static ListParser<Role> roles() {
        return Parsers.list(ROLE);
    }

    @SideEffectFree
    public static <C extends Channel> ListParser<C> channels(Class<C> type) {
        return Parsers.list(ParseUtils.channel(type));
    }
}

