/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.utils.OptionalUtils;
import dev.sympho.modular_commands.utils.parse.ChannelUrlParser;
import dev.sympho.modular_commands.utils.parse.MentionableParser;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.channel.Channel;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import reactor.core.publisher.Mono;

public class ChannelParser<C extends @NonNull Channel>
extends MentionableParser<C> {
    private final Class<C> type;
    private final ChannelUrlParser<C> urlParser;

    @Pure
    public ChannelParser(Class<C> type) {
        this.type = Objects.requireNonNull(type);
        this.urlParser = new ChannelUrlParser<C>(type);
    }

    @Pure
    private C validate(Channel channel) throws InvalidArgumentException {
        return ChannelUrlParser.validate(channel, this.type);
    }

    @Override
    public @Nullable ChannelUrlParser<C> getUrlParser() {
        return this.urlParser;
    }

    @Override
    protected Mono<C> getEntity(CommandContext context, Snowflake id) {
        return context.getGuild().flatMap(g -> g.getChannelById(id)).map(this::validate);
    }

    @Override
    public String parseMention(String mention) throws InvalidArgumentException {
        return OptionalUtils.castPresent(MentionableParser.parseMention(mention, "#")).orElseThrow(() -> new InvalidArgumentException("Not a valid channel mention: <%s>".formatted(mention)));
    }
}

