/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import com.google.common.collect.Streams;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.context.MessageCommandContext;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InputParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.SnowflakeParser;
import dev.sympho.modular_commands.api.command.parameter.parse.StringParser;
import dev.sympho.modular_commands.api.command.reply.ReplyManager;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentExtra;
import dev.sympho.modular_commands.api.exception.ResultException;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.execute.Metrics;
import dev.sympho.modular_commands.impl.context.ContextImpl;
import dev.sympho.modular_commands.impl.context.MessageReplyManager;
import dev.sympho.modular_commands.utils.StringSplitter;
import dev.sympho.modular_commands.utils.parse.RawParser;
import discord4j.common.util.Snowflake;
import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.entity.channel.PrivateChannel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MessageContextImpl
extends ContextImpl<String>
implements MessageCommandContext {
    private final MessageCreateEvent event;
    private final StringSplitter.Async.Iterator arguments;
    private @MonotonicNonNull Map<String, String> inputArgs;
    private @MonotonicNonNull Map<String, Attachment> attachmentArgs;

    public MessageContextImpl(MessageCreateEvent event, Invocation invocation, Command<?> command, StringSplitter.Async.Iterator args, AccessValidator access) throws ResultException {
        super(invocation, command, access);
        this.event = event;
        this.arguments = args;
    }

    @SideEffectFree
    private static <T> Map<String, T> assign(List<? extends Parameter<?>> parameters, List<T> arguments, Function<T, String> toString) throws ResultException {
        Map<String, Object> merged = Streams.zip(parameters.stream().map(Parameter::name), arguments.stream(), Map::entry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (merged.size() < arguments.size()) {
            List<String> extra = arguments.stream().skip(merged.size()).map(toString).toList();
            throw new ResultException(new CommandFailureArgumentExtra(extra));
        }
        return merged;
    }

    @SideEffectFree
    private static Flux<String> adjustArgs(List<Parameter<?>> parameters, StringSplitter.Async.Iterator args) {
        StringParser p;
        if (parameters.isEmpty()) {
            return Flux.empty();
        }
        int lastIdx = parameters.size() - 1;
        ArgumentParser<?, ?> last = parameters.get(lastIdx).parser();
        boolean merge = last instanceof StringParser && (p = (StringParser)last).allowMerge();
        AtomicInteger index = new AtomicInteger(0);
        return Flux.generate(sink -> {
            if (!args.hasNext()) {
                sink.complete();
            } else if (merge && index.getAndIncrement() == lastIdx) {
                sink.next((Object)args.remainder());
                sink.complete();
            } else {
                sink.next((Object)((String)args.next()));
            }
        });
    }

    @Override
    protected Mono<Void> initArgs() {
        return Mono.defer(() -> {
            List<Parameter<?>> inputParams = this.command.parameters().stream().filter(p -> p.parser() instanceof InputParser).toList();
            List<Parameter> attachmentParams = this.command.parameters().stream().filter(p -> p.parser() instanceof AttachmentParser).toList();
            List attachments = this.event.getMessage().getAttachments();
            this.attachmentArgs = MessageContextImpl.assign(attachmentParams, attachments, Attachment::getFilename);
            return MessageContextImpl.adjustArgs(inputParams, this.arguments).collectList().map(args -> MessageContextImpl.assign(inputParams, args, Function.identity())).doOnNext(args -> {
                this.inputArgs = args;
            }).then();
        });
    }

    @Override
    public Metrics.Tag.Type tagType() {
        return Metrics.Tag.Type.MESSAGE;
    }

    @Override
    protected ReplyManager makeReplyManager() {
        Message message = this.getEvent().getMessage();
        return new MessageReplyManager(message, (Mono<MessageChannel>)Mono.defer(() -> this.getChannel()), (Mono<PrivateChannel>)(this.getGuildId() == null ? null : Mono.defer(() -> this.getCaller().getPrivateChannel())), this.command.repliesDefaultPrivate(), this.command.deferReply());
    }

    private Map<String, String> getInputArgs() {
        return Objects.requireNonNullElse(this.inputArgs, Collections.emptyMap());
    }

    private Map<String, Attachment> getAttachmentArgs() {
        return Objects.requireNonNullElse(this.attachmentArgs, Collections.emptyMap());
    }

    private <P> Mono<P> parse(String name, RawParser<P> parser) {
        String raw = this.getInputArgs().get(name);
        return raw == null ? Mono.empty() : parser.parse(raw);
    }

    @Override
    protected Mono<String> getStringArgument(String name) {
        return this.parse(name, RawParser.STRING);
    }

    @Override
    protected Mono<Boolean> getBooleanArgument(String name) {
        return this.parse(name, RawParser.BOOLEAN);
    }

    @Override
    protected Mono<Long> getIntegerArgument(String name) throws InvalidArgumentException {
        return this.parse(name, RawParser.INTEGER);
    }

    @Override
    protected Mono<Double> getFloatArgument(String name) throws InvalidArgumentException {
        return this.parse(name, RawParser.FLOAT);
    }

    @Override
    protected Mono<Snowflake> getSnowflakeArgument(String name, SnowflakeParser.Type type) throws InvalidArgumentException {
        return this.parse(name, RawParser.SNOWFLAKE);
    }

    @Override
    protected Mono<User> getUserArgument(String name) {
        return this.parse(name, RawParser.user(this));
    }

    @Override
    protected Mono<Role> getRoleArgument(String name) {
        return this.parse(name, RawParser.role(this));
    }

    @Override
    protected <C extends Channel> Mono<C> getChannelArgument(String name, Class<C> type) {
        return this.parse(name, RawParser.channel(this, type));
    }

    @Override
    protected Mono<Attachment> getAttachmentArgument(String name) {
        Attachment attachment = this.getAttachmentArgs().get(name);
        return attachment == null ? Mono.empty() : Mono.just((Object)attachment);
    }

    @Override
    public User getCaller() {
        Optional author = this.event.getMessage().getAuthor();
        if (author.isPresent()) {
            return (User)author.get();
        }
        throw new IllegalStateException("Message with no author.");
    }

    @Override
    public @Nullable Member getCallerMember() {
        return this.event.getMember().orElse(null);
    }

    @Override
    public Mono<MessageChannel> getChannel() {
        return this.event.getMessage().getChannel();
    }

    @Override
    public Snowflake getChannelId() {
        return this.event.getMessage().getChannelId();
    }

    @Override
    public Mono<Guild> getGuild() {
        return this.event.getGuild();
    }

    @Override
    public @Nullable Snowflake getGuildId() {
        return this.event.getGuildId().orElse(null);
    }

    @Override
    public MessageCreateEvent getEvent() {
        return this.event;
    }
}

