/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Invocation;
import discord4j.common.util.Snowflake;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Metrics {
    public static final String PREFIX = "command";

    private Metrics() {
    }

    public static String name(String ... components) {
        return String.join((CharSequence)".", ListUtils.union(List.of(PREFIX), Arrays.asList(components)));
    }

    public static interface Tag {
        @Pure
        public String key();

        @Pure
        public String value();

        @SideEffectFree
        default public <T> Mono<T> apply(Mono<T> mono) {
            return mono.tag(this.key(), this.value());
        }

        @SideEffectFree
        default public <T> Flux<T> apply(Flux<T> flux) {
            return flux.tag(this.key(), this.value());
        }

        public record CommandId(String id) implements Tag
        {
            private static final String NAME = Metrics.name("id");

            public CommandId(String id) {
                this.id = Objects.requireNonNull(id);
            }

            public static CommandId from(String id) {
                return new CommandId(id);
            }

            @Override
            public String key() {
                return NAME;
            }

            @Override
            public String value() {
                return this.id;
            }
        }

        public record CommandInvocation(Invocation invocation, boolean canonical) implements Tag
        {
            public static final String NAME_PREFIX = "invocation";
            private static final String NAME_CALLED = Metrics.name("invocation");
            private static final String NAME_CANONICAL = Metrics.name("invocation", "canonical");

            public CommandInvocation(Invocation invocation, boolean canonical) {
                this.invocation = Objects.requireNonNull(invocation);
                this.canonical = canonical;
            }

            public static CommandInvocation called(Invocation invocation) {
                return new CommandInvocation(invocation, false);
            }

            public static CommandInvocation canonical(Invocation invocation) {
                return new CommandInvocation(invocation, true);
            }

            @Override
            public String key() {
                return this.canonical ? NAME_CANONICAL : NAME_CALLED;
            }

            @Override
            public String value() {
                return String.join((CharSequence)",", this.invocation);
            }
        }

        public record Caller(Snowflake id) implements Tag
        {
            private static final String NAME = Metrics.name("caller");

            public Caller(Snowflake id) {
                this.id = Objects.requireNonNull(id);
            }

            public static Caller from(Snowflake id) {
                return new Caller(id);
            }

            @Override
            public String key() {
                return NAME;
            }

            @Override
            public String value() {
                return this.id.asString();
            }
        }

        public record Channel(Snowflake id) implements Tag
        {
            private static final String NAME = Metrics.name("channel");

            public Channel(Snowflake id) {
                this.id = Objects.requireNonNull(id);
            }

            public static Channel from(Snowflake id) {
                return new Channel(id);
            }

            @Override
            public String key() {
                return NAME;
            }

            @Override
            public String value() {
                return this.id.asString();
            }
        }

        public record Guild(@Nullable Snowflake id) implements Tag
        {
            public static final String DM_VALUE = "none";
            public static final Guild DM = new Guild(null);
            private static final String NAME = Metrics.name("guild");

            public static Guild from(@Nullable Snowflake id) {
                return id == null ? DM : new Guild(id);
            }

            public static Guild from(Optional<Snowflake> id) {
                return id.map(Guild::new).orElse(DM);
            }

            @Override
            public String key() {
                return NAME;
            }

            @Override
            public String value() {
                return this.id == null ? DM_VALUE : this.id.asString();
            }
        }

        public static enum Type implements Tag
        {
            MESSAGE,
            SLASH;

            private static final String NAME;

            @Override
            public String key() {
                return NAME;
            }

            @Override
            public String value() {
                return this.name().toLowerCase();
            }

            static {
                NAME = Metrics.name("type");
            }
        }
    }
}

