/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.MessageHandlers;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.execute.AccessManager;
import dev.sympho.modular_commands.execute.AliasProvider;
import dev.sympho.modular_commands.execute.CommandExecutor;
import dev.sympho.modular_commands.execute.InvocationValidator;
import dev.sympho.modular_commands.execute.Metrics;
import dev.sympho.modular_commands.execute.PipelineBuilder;
import dev.sympho.modular_commands.execute.PrefixProvider;
import dev.sympho.modular_commands.impl.context.MessageContextImpl;
import dev.sympho.modular_commands.utils.StringSplitter;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import reactor.core.publisher.Mono;

public class MessageCommandExecutor
extends CommandExecutor {
    private static final Validator validator = new Validator();

    public MessageCommandExecutor(GatewayDiscordClient client, Registry registry, AccessManager accessManager, MeterRegistry meters, ObservationRegistry observations, PrefixProvider prefixProvider, AliasProvider aliases) {
        super(client, registry, new Builder(accessManager, meters, observations, prefixProvider, aliases));
    }

    private static class Builder
    extends PipelineBuilder<MessageCreateEvent, MessageContextImpl, MessageHandlers, StringSplitter.Async.Iterator> {
        private final StringSplitter.Async splitter = new StringSplitter.Shell();
        private final PrefixProvider prefixProvider;
        private final AliasProvider aliases;

        Builder(AccessManager accessManager, MeterRegistry meters, ObservationRegistry observations, PrefixProvider prefixProvider, AliasProvider aliases) {
            super(accessManager, meters, observations);
            this.prefixProvider = prefixProvider;
            this.aliases = aliases;
        }

        @Override
        protected Metrics.Tag.Type tagType() {
            return Metrics.Tag.Type.MESSAGE;
        }

        @Override
        protected Class<MessageCreateEvent> eventType() {
            return MessageCreateEvent.class;
        }

        @Override
        protected Class<MessageHandlers> commandType() {
            return MessageHandlers.class;
        }

        @Override
        protected boolean fullMatch() {
            return false;
        }

        @Override
        protected boolean eventFilter(MessageCreateEvent event) {
            Snowflake selfId = event.getClient().getSelfId();
            return event.getMessage().getAuthor().map(User::getId).map(arg_0 -> ((Snowflake)selfId).equals(arg_0)).map(BooleanUtils::negate).orElse(false);
        }

        @Override
        protected InvocationValidator<MessageCreateEvent> getValidator() {
            return validator;
        }

        @Override
        protected StringSplitter.Async.Iterator parse(MessageCreateEvent event) {
            String message = event.getMessage().getContent();
            if (message.isEmpty() || Character.isWhitespace(message.codePointAt(0))) {
                return this.splitter.emptyIterator();
            }
            String prefix = this.prefixProvider.getPrefix(event.getGuildId().orElse(null));
            if (message.startsWith(prefix)) {
                StringSplitter.Async.Iterator iter = this.splitter.iterate(message.substring(prefix.length()).trim());
                return this.aliases.apply(iter);
            }
            return this.splitter.emptyIterator();
        }

        @Override
        protected MessageContextImpl makeContext(MessageCreateEvent event, Command<? extends MessageHandlers> command, Invocation invocation, StringSplitter.Async.Iterator args) {
            AccessValidator access = this.accessValidator(event);
            return new MessageContextImpl(event, invocation, command, args, access);
        }

        @Override
        protected Optional<Snowflake> getGuildId(MessageCreateEvent event) {
            return event.getGuildId();
        }

        @Override
        protected Mono<Guild> getGuild(MessageCreateEvent event) {
            return event.getGuild();
        }

        @Override
        protected Snowflake getChannelId(MessageCreateEvent event) {
            return event.getMessage().getChannelId();
        }

        @Override
        protected Mono<MessageChannel> getChannel(MessageCreateEvent event) {
            return event.getMessage().getChannel();
        }

        @Override
        protected User getCaller(MessageCreateEvent event) {
            Optional author = event.getMessage().getAuthor();
            if (author.isPresent()) {
                return (User)author.get();
            }
            throw new IllegalStateException("Message with no author.");
        }

        @Override
        protected InvocationHandler<? super MessageContextImpl> getInvocationHandler(MessageHandlers handlers) {
            return handlers.invocation();
        }

        @Override
        protected List<? extends ResultHandler<? super MessageContextImpl>> getResultHandlers(MessageHandlers handlers) {
            return handlers.result();
        }
    }

    private static class Validator
    extends InvocationValidator<MessageCreateEvent> {
        Validator() {
        }

        @Override
        protected User getCaller(MessageCreateEvent event) {
            Optional author = event.getMessage().getAuthor();
            return (User)author.get();
        }

        @Override
        protected Mono<MessageChannel> getChannel(MessageCreateEvent event) {
            return event.getMessage().getChannel();
        }

        @Override
        protected Mono<Guild> getGuild(MessageCreateEvent event) {
            return event.getGuild();
        }
    }
}

